/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.gravatar;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.gravatar.Gravatar;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.LangUtils;

public class GravatarRenderer
extends CoreRenderer {
    private static final String BASE_URL = "www.gravatar.com";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.encodeMarkup(context, (Gravatar)component);
    }

    private void encodeMarkup(FacesContext context, Gravatar gravatar) throws IOException {
        String url;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("img", (UIComponent)gravatar);
        writer.writeAttribute("id", (Object)gravatar.getClientId(), null);
        writer.writeAttribute("style", (Object)gravatar.getStyle(), null);
        try {
            url = this.generateURL(gravatar);
        }
        catch (NoSuchAlgorithmException e) {
            throw new FacesException((Throwable)e);
        }
        writer.writeAttribute("src", (Object)url, null);
        writer.endElement("img");
    }

    private String generateURL(Gravatar gravatar) throws NoSuchAlgorithmException {
        boolean qrCode = gravatar.isQrCode();
        Integer size = gravatar.getSize();
        String notFound = gravatar.getNotFound();
        String url = gravatar.isSecure() ? "https://www.gravatar.com/" : "http://www.gravatar.com/";
        if (!qrCode) {
            url = url + "avatar/";
        }
        url = url + this.generateMailHash(gravatar);
        url = url + (qrCode ? ".qr" : ".jpg");
        ArrayList<String> params = new ArrayList<String>();
        if (size != null) {
            params.add("s=" + size);
        }
        if (!LangUtils.isValueBlank((String)notFound) && (!"default".equals(notFound) && Gravatar.NOT_FOUND_VALUES.contains(notFound) || notFound.startsWith("http"))) {
            params.add("d=" + notFound);
        }
        if (!params.isEmpty()) {
            url = url + "?" + String.join((CharSequence)"&", params.toArray(new String[params.size()]));
        }
        return url;
    }

    private String generateMailHash(Gravatar gravatar) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(String.valueOf(gravatar.getValue()).getBytes(StandardCharsets.UTF_8));
        byte[] digest = md.digest();
        StringBuilder sb = new StringBuilder(1024);
        for (byte b : digest) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }
}

