/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.letteravatar;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.letteravatar.LetterAvatar;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.LangUtils;

public class LetterAvatarRenderer
extends CoreRenderer {
    private static final Pattern VALUE_PATTTERN = Pattern.compile("\\b[a-zA-Z]");

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        LetterAvatar letterAvatar = (LetterAvatar)component;
        this.encodeMarkup(context, letterAvatar);
    }

    public void encodeMarkup(FacesContext context, LetterAvatar letterAvatar) throws IOException {
        String backgroundColor;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = letterAvatar.getClientId(context);
        String value = letterAvatar.getValue();
        Matcher m = VALUE_PATTTERN.matcher(value);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            sb.append(m.group());
        }
        String initials = sb.toString();
        initials = initials.length() == 1 ? initials : initials.charAt(0) + initials.substring(initials.length() - 1);
        boolean rounded = letterAvatar.isRounded();
        String color = letterAvatar.getColor();
        if (LangUtils.isValueBlank((String)color)) {
            color = "#fff";
        }
        if (LangUtils.isValueBlank((String)(backgroundColor = letterAvatar.getBackgroundColor()))) {
            backgroundColor = "hsl(" + LetterAvatarRenderer.hue(value) + ", 100%, 50%)";
        }
        String size = letterAvatar.getSize();
        String style = this.styleContainer(size, color, backgroundColor);
        if (!LangUtils.isValueBlank((String)letterAvatar.getStyle())) {
            style = style + letterAvatar.getStyle();
        }
        String styleClass = this.getStyleClassBuilder(context).add("ui-letteravatar").add(letterAvatar.getStyleClass()).add(rounded, "ui-letteravatar-rounded").build();
        writer.startElement("span", (UIComponent)letterAvatar);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("title", (Object)value, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        writer.writeAttribute("style", (Object)style, "style");
        this.renderChildren(context, (UIComponent)letterAvatar);
        writer.startElement("span", (UIComponent)letterAvatar);
        writer.writeAttribute("class", (Object)"ui-letteravatar-initials", null);
        writer.writeAttribute("style", (Object)this.styleInitials(size), null);
        writer.write(initials);
        writer.endElement("span");
        writer.endElement("span");
    }

    public void encodeChildren(FacesContext context, UIComponent component) {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public static int hue(String str) {
        return Math.abs(str.hashCode() % 40 * 9);
    }

    protected String styleContainer(String size, String color, String backgroundColor) {
        return "color:" + color + ";background-color:" + backgroundColor + ";height:" + size + ";width:" + size + ";";
    }

    protected String styleInitials(String size) {
        return "font-size:calc(" + size + "/2);line-height:" + size + ";";
    }
}

