/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.monacoeditor;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.extensions.component.monacoeditor.MonacoEditorBase;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.shaded.json.JSONWriter;
import org.primefaces.shaded.owasp.encoder.Encode;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

abstract class MonacoEditorBaseRenderer<T extends MonacoEditorBase>
extends InputRenderer {
    private static final String CALLBACK_SIGNATURE = "function()";
    private static final List<String> PASSTHROUGH_ATTRS = Arrays.asList("alt", "accesskey", "autocomplete", "cols", "dir", "lang", "maxlength", "placeholder", "rows", "size", "title");
    private final Class<T> componentClass;

    protected MonacoEditorBaseRenderer(Class<T> clazz) {
        this.componentClass = clazz;
    }

    protected abstract void addWidgetProperties(WidgetBuilder var1, T var2) throws IOException;

    protected void array(WidgetBuilder wb, String key, Iterable<String> values) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (String item : values) {
            builder.append('\"');
            builder.append(Encode.forJavaScript((String)item));
            builder.append('\"');
            builder.append(',');
        }
        if (builder.length() > 1) {
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        wb.nativeAttr(key, builder.toString());
    }

    public void decode(FacesContext context, UIComponent component) {
        MonacoEditorBase monacoEditor = (MonacoEditorBase)((Object)this.componentClass.cast(component));
        if (monacoEditor.isDisabled() || monacoEditor.isReadonly()) {
            return;
        }
        String clientId = monacoEditor.getClientId() + "_input";
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId)) {
            monacoEditor.setSubmittedValue(params.get(clientId));
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        MonacoEditorBase monacoEditor = (MonacoEditorBase)((Object)this.componentClass.cast(component));
        this.encodeMarkup(context, monacoEditor);
        this.encodeScript(context, monacoEditor);
    }

    protected void encodeHiddenInput(FacesContext context, T monacoEditor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = monacoEditor.getClientId();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("textarea", monacoEditor);
        writer.writeAttribute("id", (Object)(clientId + "_input"), null);
        writer.writeAttribute("name", (Object)(clientId + "_input"), null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (monacoEditor.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (monacoEditor.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        this.renderPassThruAttributes(context, (UIComponent)monacoEditor, PASSTHROUGH_ATTRS);
        String valueToRender = ComponentUtils.getValueToRender((FacesContext)context, monacoEditor);
        if (valueToRender != null) {
            writer.writeText((Object)valueToRender, null);
        }
        writer.endElement("textarea");
        writer.endElement("div");
    }

    protected void encodeMarkup(FacesContext context, T monacoEditor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = monacoEditor.getClientId();
        String style = monacoEditor.getStyle() != null ? monacoEditor.getStyle() : "";
        style = style.concat(";");
        if (((MonacoEditorBase)((Object)monacoEditor)).getWidth() != null && !((MonacoEditorBase)((Object)monacoEditor)).getWidth().isEmpty()) {
            style = style.concat("width:" + ((MonacoEditorBase)((Object)monacoEditor)).getWidth() + ";");
        }
        if (((MonacoEditorBase)((Object)monacoEditor)).getHeight() != null && !((MonacoEditorBase)((Object)monacoEditor)).getHeight().isEmpty()) {
            style = style.concat("height:" + ((MonacoEditorBase)((Object)monacoEditor)).getHeight() + ";");
        }
        StringBuilder styleClass = new StringBuilder();
        styleClass.append(this.getMainStyleClass() + " ui-hidden-container ");
        if (monacoEditor.isDisabled() || monacoEditor.isReadonly()) {
            styleClass.append("ui-state-disabled ");
        }
        if (monacoEditor.getStyleClass() != null) {
            styleClass.append(monacoEditor.getStyleClass());
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("data-widget-var", (Object)monacoEditor.resolveWidgetVar(), null);
        writer.writeAttribute("class", (Object)styleClass.toString(), null);
        writer.writeAttribute("style", (Object)style, null);
        this.encodeHiddenInput(context, monacoEditor);
        this.encodeMonacoEditor(context, monacoEditor);
        writer.endElement("div");
    }

    protected abstract void encodeMonacoEditor(FacesContext var1, T var2) throws IOException;

    protected void encodeScript(FacesContext context, T monacoEditor) throws IOException {
        WidgetBuilder wb = PrimeRequestContext.getCurrentInstance((FacesContext)context).getWidgetBuilder();
        wb.init(this.getWidgetName(), monacoEditor);
        this.array(wb, "availableEvents", ((MonacoEditorBase)((Object)monacoEditor)).getEventNames());
        if (((MonacoEditorBase)((Object)monacoEditor)).getCustomThemes() != null && !((MonacoEditorBase)((Object)monacoEditor)).getCustomThemes().isEmpty()) {
            wb.nativeAttr("customThemes", JSONWriter.valueToString(((MonacoEditorBase)((Object)monacoEditor)).getCustomThemes()));
        }
        wb.attr("autoResize", ((MonacoEditorBase)((Object)monacoEditor)).isAutoResize(), false);
        wb.attr("basename", ((MonacoEditorBase)((Object)monacoEditor)).getBasename(), "");
        wb.attr("directory", ((MonacoEditorBase)((Object)monacoEditor)).getDirectory(), "");
        wb.attr("disabled", monacoEditor.isDisabled(), false);
        wb.attr("editorOptions", ((MonacoEditorBase)((Object)monacoEditor)).getEditorOptions().toString());
        wb.attr("extension", ((MonacoEditorBase)((Object)monacoEditor)).getExtension(), "");
        wb.attr("language", ((MonacoEditorBase)((Object)monacoEditor)).getEditorOptions().getLanguage(), "plaintext");
        wb.attr("locale", ((MonacoEditorBase)((Object)monacoEditor)).calculateLocale().toString());
        wb.attr("localeUrl", ((MonacoEditorBase)((Object)monacoEditor)).getLocaleUrl());
        wb.attr("readonly", monacoEditor.isReadonly(), false);
        wb.attr("scheme", ((MonacoEditorBase)((Object)monacoEditor)).getScheme(), "inmemory");
        wb.attr("tabIndex", monacoEditor.getTabindex(), MonacoEditorBase.DEFAULT_TABINDEX);
        wb.attr("height", ((MonacoEditorBase)((Object)monacoEditor)).getHeight(), "600px");
        wb.attr("width", ((MonacoEditorBase)((Object)monacoEditor)).getWidth(), "200px");
        wb.callback("onblur", CALLBACK_SIGNATURE, monacoEditor.getOnblur());
        wb.callback("onchange", CALLBACK_SIGNATURE, monacoEditor.getOnchange());
        wb.callback("onfocus", CALLBACK_SIGNATURE, monacoEditor.getOnfocus());
        wb.callback("oninitialized", CALLBACK_SIGNATURE, ((MonacoEditorBase)((Object)monacoEditor)).getOninitialized());
        wb.callback("onkeyup", CALLBACK_SIGNATURE, monacoEditor.getOnkeyup());
        wb.callback("onmousedown", CALLBACK_SIGNATURE, monacoEditor.getOnmousedown());
        wb.callback("onmousemove", CALLBACK_SIGNATURE, monacoEditor.getOnmousemove());
        wb.callback("onmouseup", CALLBACK_SIGNATURE, monacoEditor.getOnmouseup());
        wb.callback("onkeydown", CALLBACK_SIGNATURE, monacoEditor.getOnkeydown());
        wb.callback("onpaste", CALLBACK_SIGNATURE, ((MonacoEditorBase)((Object)monacoEditor)).getOnpaste());
        this.addWidgetProperties(wb, monacoEditor);
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)monacoEditor);
        wb.finish();
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) {
        MonacoEditorBase monacoEditor = (MonacoEditorBase)((Object)this.componentClass.cast(component));
        String value = (String)submittedValue;
        Converter converter = ComponentUtils.getConverter((FacesContext)context, (UIComponent)monacoEditor);
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)monacoEditor, value);
        }
        return value;
    }

    protected abstract String getMainStyleClass();

    protected abstract String getWidgetName();
}

