/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.timeago;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.Widget;
import org.primefaces.util.LocaleUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces-extensions", name="primefaces-extensions.js"), @ResourceDependency(library="primefaces-extensions", name="timeago/timeago.js")})
public class TimeAgo
extends UIComponentBase
implements Widget {
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.TimeAgo";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    public static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.TimeAgoRenderer";
    public static final String STYLE_CLASS = "ui-timeago ui-widget";
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private Locale appropriateLocale;

    public TimeAgo() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public Object getValue() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.value), null);
    }

    public void setValue(String value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.value), (Object)value);
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)widgetVar);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)styleClass);
    }

    public Object getLocale() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.locale), null);
    }

    public void setLocale(Object locale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.locale), locale);
    }

    public String getTitlePattern() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.titlePattern), null);
    }

    public void setTitlePattern(String titlePattern) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.titlePattern), (Object)titlePattern);
    }

    public Locale calculateLocale() {
        if (this.appropriateLocale == null) {
            FacesContext fc = FacesContext.getCurrentInstance();
            this.appropriateLocale = LocaleUtils.resolveLocale((FacesContext)fc, (Object)this.getLocale(), (String)this.getClientId(fc));
        }
        return this.appropriateLocale;
    }

    public final String formattedForJs() {
        return this.format(DATE_FORMAT, ZoneId.of("UTC"));
    }

    public final String formattedForTitle() {
        Object value = this.getValue();
        ZoneId zone = value instanceof ZonedDateTime ? ((ZonedDateTime)value).getZone() : ZoneId.systemDefault();
        return this.format(this.getTitlePattern(), zone);
    }

    protected String format(String pattern, ZoneId zone) {
        Object value = this.getValue();
        if (value instanceof Date) {
            return this.format((Date)value, pattern, zone);
        }
        if (value instanceof ZonedDateTime) {
            return this.format((ZonedDateTime)value, pattern, zone);
        }
        if (value instanceof LocalDateTime) {
            return this.format((LocalDateTime)value, pattern, zone);
        }
        throw new IllegalArgumentException("Unsupported type");
    }

    protected String format(Date value, String pattern, ZoneId zone) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, this.calculateLocale());
        sdf.setTimeZone(TimeZone.getTimeZone(zone));
        return sdf.format(value);
    }

    protected String format(ZonedDateTime dateTime, String pattern, ZoneId zone) {
        return dateTime.withZoneSameInstant(zone).format(DateTimeFormatter.ofPattern(pattern));
    }

    protected String format(LocalDateTime dateTime, String pattern, ZoneId zone) {
        return this.format(dateTime.atZone(ZoneId.systemDefault()), pattern, zone);
    }

    public static enum PropertyKeys {
        value,
        widgetVar,
        style,
        styleClass,
        locale,
        titlePattern;

    }
}

