/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.converter;

import java.io.Serializable;
import java.util.Locale;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.FacesConverter;
import org.primefaces.extensions.util.ExtLangUtils;
import org.primefaces.util.LangUtils;

@FacesConverter(value="org.primefaces.extensions.converter.LocaleConverter")
public class LocaleConverter
implements Converter<Object>,
Serializable {
    private static final long serialVersionUID = 20121214L;
    private char separator = (char)95;

    public Object getAsObject(FacesContext fc, UIComponent component, String value) {
        if (LangUtils.isValueBlank((String)value)) {
            return fc.getApplication().getDefaultLocale();
        }
        return LocaleConverter.getLocaleObject(value, this.separator);
    }

    public String getAsString(FacesContext fc, UIComponent component, Object value) {
        if (value == null) {
            Locale defaultLocale = fc.getApplication().getDefaultLocale();
            if (defaultLocale == null) {
                return null;
            }
            return LocaleConverter.getLocaleString(defaultLocale, this.separator);
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Locale) {
            return LocaleConverter.getLocaleString((Locale)value, this.separator);
        }
        throw new ConverterException(new FacesMessage(FacesMessage.SEVERITY_ERROR, "Wrong type: '" + value.getClass().getSimpleName() + "' is not 'Locale'.", ""));
    }

    public static Locale getLocaleObject(String locale, char seperator) {
        String[] parts;
        String replacedLocale = locale;
        if (seperator != '-' && seperator != '_') {
            replacedLocale = replacedLocale.replace(seperator, '_');
        }
        if ((parts = (replacedLocale = replacedLocale.replace('-', '_')).split("_")).length == 0 || !parts[0].matches("[a-zA-Z]{2,2}") || parts.length > 1 && parts[1].length() != 0 && !parts[1].matches("[a-zA-Z]{2,2}")) {
            throw new ConverterException(new FacesMessage(FacesMessage.SEVERITY_ERROR, "'" + locale + "' does not represent a valid locale", ""));
        }
        switch (parts.length) {
            case 3: {
                return new Locale(parts[0], parts[1], parts[2]);
            }
            case 2: {
                return new Locale(parts[0], parts[1]);
            }
            case 1: {
                return new Locale(parts[0]);
            }
        }
        CharSequence[] arr = ExtLangUtils.subarray(parts, 2, parts.length);
        return new Locale(parts[0], parts[1], String.join((CharSequence)"_", arr));
    }

    public static String getLocaleString(Locale locale, char seperator) {
        if (LangUtils.isValueBlank((String)locale.getCountry())) {
            return locale.getLanguage();
        }
        return locale.getLanguage() + seperator + locale.getCountry();
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }
}

