/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.sheet;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.FacesEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.primefaces.PrimeFaces;
import org.primefaces.extensions.component.sheet.BeanPropertyComparator;
import org.primefaces.extensions.component.sheet.SheetBase;
import org.primefaces.extensions.component.sheet.SheetColumn;
import org.primefaces.extensions.component.sheet.SheetInvalidUpdate;
import org.primefaces.extensions.event.SheetEvent;
import org.primefaces.extensions.model.sheet.SheetRowColIndex;
import org.primefaces.extensions.model.sheet.SheetUpdate;
import org.primefaces.extensions.util.ExtLangUtils;
import org.primefaces.extensions.util.JavascriptVarBuilder;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces-extensions", name="primefaces-extensions.js"), @ResourceDependency(library="primefaces-extensions", target="head", name="sheet/sheet.css"), @ResourceDependency(library="primefaces-extensions", name="sheet/sheet.js")})
public class Sheet
extends SheetBase {
    public static final String EVENT_CELL_SELECT = "cellSelect";
    public static final String EVENT_CHANGE = "change";
    public static final String EVENT_SORT = "sort";
    public static final String EVENT_FILTER = "filter";
    public static final String EVENT_COLUMN_SELECT = "columnSelect";
    public static final String EVENT_ROW_SELECT = "rowSelect";
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.Sheet";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("change", "cellSelect", "sort", "filter", "columnSelect", "rowSelect"));
    private List<SheetColumn> columns;
    private List<SheetInvalidUpdate> invalidUpdates;
    private final Map<SheetRowColIndex, String> submittedValues = new ConcurrentHashMap<SheetRowColIndex, String>();
    private final Map<SheetRowColIndex, Object> localValues = new ConcurrentHashMap<SheetRowColIndex, Object>();
    private String selection;
    private String focusId;
    private final List<SheetUpdate> updates = new ArrayList<SheetUpdate>();
    private Map<Integer, Integer> columnMapping;
    private Map<String, Object> rowMap;
    private Map<String, Integer> rowNumbers;

    @Override
    public String getFamily() {
        return "org.primefaces.extensions.component";
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return EVENT_CHANGE;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext fc = FacesContext.getCurrentInstance();
        if (this.isSelfRequest(fc) && event instanceof AjaxBehaviorEvent) {
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            SheetEvent sheetEvent = new SheetEvent((UIComponent)this, behaviorEvent.getBehavior());
            sheetEvent.setPhaseId(event.getPhaseId());
            super.queueEvent((FacesEvent)sheetEvent);
            return;
        }
        super.queueEvent(event);
    }

    private boolean isSelfRequest(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("jakarta.faces.source"));
    }

    public List<SheetColumn> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<SheetColumn>();
            this.getColumns((UIComponent)this);
        }
        return this.columns;
    }

    public List<SheetColumn> getRenderedColumns() {
        List<SheetColumn> allColumns = this.getColumns();
        ArrayList<SheetColumn> renderedCols = new ArrayList<SheetColumn>(allColumns.size());
        for (SheetColumn column : allColumns) {
            if (!column.isRendered()) continue;
            renderedCols.add(column);
        }
        return renderedCols;
    }

    private List<SheetColumn> getColumns(UIComponent parent) {
        for (UIComponent child : parent.getChildren()) {
            if (!(child instanceof SheetColumn)) continue;
            this.columns.add((SheetColumn)child);
        }
        return this.columns;
    }

    public void setColumns(List<SheetColumn> columns) {
        this.columns = columns;
    }

    public List<SheetInvalidUpdate> getInvalidUpdates() {
        if (this.invalidUpdates == null) {
            this.invalidUpdates = new ArrayList<SheetInvalidUpdate>();
        }
        return this.invalidUpdates;
    }

    public void resetSubmitted() {
        this.submittedValues.clear();
        this.updates.clear();
    }

    public void resetSort() {
        this.getStateHelper().put((Serializable)((Object)SheetBase.PropertyKeys.currentSortBy.name()), null);
        String origSortOrder = (String)this.getStateHelper().get((Serializable)((Object)SheetBase.PropertyKeys.origSortOrder));
        if (origSortOrder != null) {
            this.setSortOrder(origSortOrder);
        }
    }

    public void resetInvalidUpdates() {
        this.getInvalidUpdates().clear();
    }

    public void reset() {
        this.resetSubmitted();
        this.resetSort();
        this.resetInvalidUpdates();
        this.localValues.clear();
        for (SheetColumn c : this.getColumns()) {
            c.setFilterValue(null);
        }
    }

    public void setSubmittedValue(String rowKey, int col, String value) {
        this.submittedValues.put(new SheetRowColIndex(rowKey, col), value);
    }

    public String getSubmittedValue(String rowKey, int col) {
        return this.submittedValues.get(new SheetRowColIndex(rowKey, col));
    }

    public void setLocalValue(String rowKey, int col, Object value) {
        SheetRowColIndex key = new SheetRowColIndex(rowKey, col);
        if (value != null) {
            this.localValues.put(key, value);
        } else {
            this.localValues.remove(key);
        }
    }

    public Object getLocalValue(String rowKey, int col) {
        return this.localValues.get(new SheetRowColIndex(rowKey, col));
    }

    public void setRowVar(FacesContext context, String rowKey) {
        if (context == null) {
            return;
        }
        if (rowKey == null) {
            context.getExternalContext().getRequestMap().remove(this.getVar());
        } else {
            Object value = this.getRowMap().get(rowKey);
            context.getExternalContext().getRequestMap().put(this.getVar(), value);
        }
    }

    protected Map<String, Object> getRowMap() {
        if (this.rowMap == null || this.rowMap.isEmpty()) {
            this.remapRows();
        }
        return this.rowMap;
    }

    public Object getValueForCell(FacesContext context, String rowKey, int col) {
        SheetRowColIndex index = new SheetRowColIndex(rowKey, col);
        if (this.localValues.containsKey(index)) {
            return this.localValues.get(index);
        }
        this.setRowVar(context, rowKey);
        SheetColumn column = this.getColumns().get(col);
        ValueExpression ve = column.getValueExpression("value");
        if (ve != null) {
            return ve.getValue(context.getELContext());
        }
        return column.getValue();
    }

    public String getRenderValueForCell(FacesContext context, String rowKey, int col) {
        SheetRowColIndex index = new SheetRowColIndex(rowKey, col);
        if (this.submittedValues.containsKey(index)) {
            return this.submittedValues.get(index);
        }
        Object value = this.getValueForCell(context, rowKey, col);
        if (value == null) {
            return null;
        }
        SheetColumn column = this.getColumns().get(col);
        Converter converter = ComponentUtils.getConverter((FacesContext)context, (UIComponent)column);
        if (converter == null) {
            return value.toString();
        }
        return converter.getAsString(context, (UIComponent)this, value);
    }

    protected String getRowHeaderValueAsString(FacesContext context) {
        ValueExpression veRowHeader = this.getRowHeaderValueExpression();
        Object value = veRowHeader.getValue(context.getELContext());
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public List<Object> getSortedValues() {
        List<Object> filtered = this.getFilteredValue();
        if (filtered == null || filtered.isEmpty()) {
            filtered = this.sortAndFilter();
        }
        return filtered;
    }

    public int getSortColRenderIndex() {
        String currentSortById = (String)this.getStateHelper().get((Serializable)((Object)SheetBase.PropertyKeys.currentSortBy.name()));
        if (LangUtils.isEmpty((String)currentSortById)) {
            Object sortBy = this.getStateHelper().eval((Serializable)((Object)SheetBase.PropertyKeys.sortBy.name()));
            if (sortBy instanceof String) {
                currentSortById = (String)sortBy;
            }
        } else {
            int colIdx = 0;
            for (SheetColumn column : this.getColumns()) {
                if (!column.isRendered()) continue;
                if (currentSortById.equals(column.getId())) {
                    return colIdx;
                }
                ++colIdx;
            }
        }
        ValueExpression veSortBy = this.getValueExpression(SheetBase.PropertyKeys.sortBy.name());
        if (veSortBy == null) {
            return -1;
        }
        String sortByExp = veSortBy.getExpressionString();
        int colIdx = 0;
        for (SheetColumn column : this.getColumns()) {
            if (!column.isRendered()) continue;
            ValueExpression veCol = column.getValueExpression(SheetBase.PropertyKeys.sortBy.name());
            if (veCol != null && veCol.getExpressionString().equals(sortByExp)) {
                return colIdx;
            }
            ++colIdx;
        }
        return -1;
    }

    protected boolean matchesFilter() {
        block10: for (SheetColumn col : this.getColumns()) {
            String filterValue = col.getFilterValue();
            if (LangUtils.isBlank((String)filterValue)) continue;
            Object filterBy = col.getFilterBy();
            if (filterBy == null) {
                return false;
            }
            String filterMatchMode = col.getFilterMatchMode();
            if (LangUtils.isBlank((String)filterMatchMode)) {
                filterMatchMode = "contains";
            }
            String value = filterBy.toString().toLowerCase();
            String filter = filterValue.toLowerCase();
            switch (filterMatchMode) {
                case "startsWith": {
                    if (value.startsWith(filter)) continue block10;
                    return false;
                }
                case "endsWith": {
                    if (value.endsWith(filter)) continue block10;
                    return false;
                }
                case "exact": {
                    if (value.equals(filter)) continue block10;
                    return false;
                }
            }
            if (value.contains(filter)) continue;
            return false;
        }
        return true;
    }

    public List<Object> sortAndFilter() {
        ArrayList<Object> filteredList = this.getFilteredValue();
        if (filteredList == null) {
            filteredList = new ArrayList<Object>();
        }
        filteredList.clear();
        this.rowMap = new HashMap<String, Object>();
        this.rowNumbers = new HashMap<String, Integer>();
        Collection values = (Collection)this.getValue();
        if (values == null || values.isEmpty()) {
            return filteredList;
        }
        this.remapRows();
        List<SheetColumn> columns = this.getRenderedColumns();
        boolean filters = false;
        for (SheetColumn col : columns) {
            if (!LangUtils.isNotBlank((String)col.getFilterValue())) continue;
            filters = true;
            break;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestMap = context.getExternalContext().getRequestMap();
        String var = this.getVar();
        if (filters) {
            for (Object obj : values) {
                requestMap.put(var, obj);
                if (!this.matchesFilter()) continue;
                filteredList.add(obj);
            }
        } else {
            filteredList.addAll(values);
        }
        int sortByIdx = this.getSortColRenderIndex();
        SheetColumn currentSortByColumn = sortByIdx >= 0 ? columns.get(sortByIdx) : null;
        ValueExpression currentSortByVe = currentSortByColumn != null ? currentSortByColumn.getValueExpression(SheetBase.PropertyKeys.sortBy.name()) : null;
        ValueExpression veSortBy = currentSortByVe != null ? currentSortByVe : this.getValueExpression(SheetBase.PropertyKeys.sortBy.name());
        if (veSortBy != null) {
            SortMeta sortMeta = SortMeta.builder().field("field").caseSensitiveSort(this.isCaseSensitiveSort()).sortBy(veSortBy).order(this.convertSortOrder()).nullSortOrder(this.getNullSortOrder().intValue()).build();
            filteredList.sort(new BeanPropertyComparator(var, sortMeta, Locale.ENGLISH));
        }
        this.remapFilteredList(filteredList);
        return filteredList;
    }

    protected void remapFilteredList(List filteredList) {
        this.rowNumbers = new HashMap<String, Integer>(this.rowMap.size());
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestMap = context.getExternalContext().getRequestMap();
        String var = this.getVar();
        int row = 0;
        for (Object value : filteredList) {
            requestMap.put(var, value);
            this.rowNumbers.put(this.getRowKeyValueAsString(context), row);
            ++row;
        }
        requestMap.remove(var);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remapRows() {
        this.rowMap = new HashMap<String, Object>();
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestMap = context.getExternalContext().getRequestMap();
        Collection values = (Collection)this.getValue();
        String var = this.getVar();
        for (Object obj : values) {
            requestMap.put(var, obj);
            try {
                String key = this.getRowKeyValueAsString(context);
                this.rowMap.put(key, obj);
            }
            finally {
                requestMap.remove(var);
            }
        }
    }

    @Override
    protected Object getRowKeyValue(FacesContext context) {
        ValueExpression veRowKey = this.getValueExpression(SheetBase.PropertyKeys.rowKey.name());
        if (veRowKey == null) {
            throw new FacesException("RowKey required on sheet!");
        }
        Object value = veRowKey.getValue(context.getELContext());
        if (value == null) {
            throw new FacesException("RowKey must resolve to non-null value for updates to work properly");
        }
        return value;
    }

    protected String getRowKeyValueAsString(Object key) {
        String result = key.toString();
        return "r_" + ExtLangUtils.deleteWhitespace(result);
    }

    protected String getRowKeyValueAsString(FacesContext context) {
        return this.getRowKeyValueAsString(this.getRowKeyValue(context));
    }

    protected SortOrder convertSortOrder() {
        String sortOrder = this.getSortOrder();
        if (sortOrder == null) {
            return SortOrder.UNSORTED;
        }
        return SortOrder.valueOf((String)sortOrder.toUpperCase(Locale.ENGLISH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(FacesContext context) {
        Iterator<Map.Entry<SheetRowColIndex, String>> entries = this.submittedValues.entrySet().iterator();
        boolean hadBadUpdates = !this.getInvalidUpdates().isEmpty();
        this.getInvalidUpdates().clear();
        while (entries.hasNext()) {
            Map.Entry<SheetRowColIndex, String> entry = entries.next();
            SheetColumn column = this.getColumns().get(entry.getKey().getColIndex());
            String newValue = entry.getValue();
            String rowKey = entry.getKey().getRowKey();
            int col = entry.getKey().getColIndex();
            this.setRowVar(context, rowKey);
            Converter converter = ComponentUtils.getConverter((FacesContext)context, (UIComponent)column);
            Object newValueObj = newValue;
            if (converter != null) {
                try {
                    newValueObj = converter.getAsObject(context, (UIComponent)this, newValue);
                }
                catch (ConverterException e) {
                    this.setValid(false);
                    FacesMessage message = e.getFacesMessage();
                    if (message == null) {
                        message = new FacesMessage(FacesMessage.SEVERITY_ERROR, e.getMessage(), e.getMessage());
                    }
                    context.addMessage(this.getClientId(context), message);
                    String messageText = message.getDetail();
                    this.getInvalidUpdates().add(new SheetInvalidUpdate(this.getRowKeyValue(context), col, column, newValue, messageText));
                    continue;
                }
            }
            this.setLocalValue(rowKey, col, newValueObj);
            column.setValue(newValueObj);
            try {
                column.validate(context);
            }
            finally {
                column.resetValue();
            }
            entries.remove();
        }
        this.setRowVar(context, null);
        boolean newBadUpdates = !this.getInvalidUpdates().isEmpty();
        String errorMessage = this.getErrorMessage();
        if ((hadBadUpdates || newBadUpdates) && context.getPartialViewContext().isPartialRequest()) {
            this.renderBadUpdateScript();
        }
        if (newBadUpdates && errorMessage != null) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, errorMessage, errorMessage);
            context.addMessage(null, message);
        }
    }

    public void updateModel(FacesContext context) {
        Iterator<Map.Entry<SheetRowColIndex, Object>> entries = this.localValues.entrySet().iterator();
        HashSet<String> dirtyRows = new HashSet<String>();
        while (entries.hasNext()) {
            Map.Entry<SheetRowColIndex, Object> entry = entries.next();
            Object newValue = entry.getValue();
            String rowKey = entry.getKey().getRowKey();
            int col = entry.getKey().getColIndex();
            SheetColumn column = this.getColumns().get(col);
            this.setRowVar(context, rowKey);
            Object rowVal = this.rowMap.get(rowKey);
            ValueExpression ve = column.getValueExpression(SheetBase.PropertyKeys.value.name());
            ELContext elContext = context.getELContext();
            Object oldValue = ve.getValue(elContext);
            ve.setValue(elContext, newValue);
            entries.remove();
            this.appendUpdateEvent(this.getRowKeyValue(context), col, rowVal, oldValue, newValue);
            dirtyRows.add(rowKey);
        }
        this.setLocalValueSet(false);
        this.setRowVar(context, null);
        if (context.getPartialViewContext().isPartialRequest()) {
            this.renderRowUpdateScript(context, dirtyRows);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.submittedValues, this.localValues, this.invalidUpdates, this.columnMapping, this.getFilteredValue(), this.rowMap, this.rowNumbers};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        if (state == null) {
            return;
        }
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        Object restoredSubmittedValues = values[1];
        Object restoredLocalValues = values[2];
        Object restoredInvalidUpdates = values[3];
        Object restoredColMappings = values[4];
        Object restoredSortedList = values[5];
        Object restoredRowMap = values[6];
        Object restoredRowNumbers = values[7];
        this.submittedValues.clear();
        if (restoredSubmittedValues != null) {
            this.submittedValues.putAll((Map)restoredSubmittedValues);
        }
        this.localValues.clear();
        if (restoredLocalValues != null) {
            this.localValues.putAll((Map)restoredLocalValues);
        }
        if (restoredInvalidUpdates == null) {
            this.getInvalidUpdates().clear();
        } else {
            this.invalidUpdates = (List)restoredInvalidUpdates;
        }
        this.columnMapping = restoredColMappings == null ? null : (Map)restoredColMappings;
        if (restoredSortedList == null) {
            this.getFilteredValue().clear();
        } else {
            this.setFilteredValue((List)restoredSortedList);
        }
        this.rowMap = restoredRowMap == null ? null : (Map)restoredRowMap;
        this.rowNumbers = restoredRowNumbers == null ? null : (Map)restoredRowNumbers;
    }

    public String getSelection() {
        return this.selection;
    }

    public void setSelection(String selection) {
        this.selection = selection;
    }

    public Object getSubmittedValue() {
        if (this.submittedValues.isEmpty()) {
            return null;
        }
        return this.submittedValues;
    }

    public void setSubmittedValue(Object submittedValue) {
        this.submittedValues.clear();
        if (submittedValue != null) {
            this.submittedValues.putAll((Map)submittedValue);
        }
    }

    public List<SheetUpdate> getUpdates() {
        return this.updates;
    }

    public boolean isHasStyledCells() {
        for (SheetColumn column : this.getColumns()) {
            if (column.getStyleClass() == null) continue;
            return true;
        }
        return false;
    }

    public int getMappedColumn(int renderCol) {
        if (this.columnMapping == null || renderCol == -1) {
            return renderCol;
        }
        Integer result = this.columnMapping.get(renderCol);
        if (result == null) {
            throw new IllegalArgumentException("Invalid index " + renderCol);
        }
        return result;
    }

    public int getRenderIndexFromRealIdx(int realIdx) {
        if (this.columnMapping == null || realIdx == -1) {
            return realIdx;
        }
        for (Map.Entry<Integer, Integer> entry : this.columnMapping.entrySet()) {
            if (!entry.getValue().equals(realIdx)) continue;
            return entry.getKey();
        }
        return realIdx;
    }

    public void updateColumnMappings() {
        this.columnMapping = new HashMap<Integer, Integer>();
        int realIdx = 0;
        int renderCol = 0;
        for (SheetColumn column : this.getColumns()) {
            if (column.isRendered()) {
                this.columnMapping.put(renderCol, realIdx);
                ++renderCol;
            }
            ++realIdx;
        }
    }

    public int getRowCount() {
        return this.getSortedValues().size();
    }

    public String getFocusId() {
        return this.focusId;
    }

    public void setFocusId(String focusId) {
        this.focusId = focusId;
    }

    public void commitUpdates() {
        this.resetSubmitted();
        FacesContext context = FacesContext.getCurrentInstance();
        if (context.getPartialViewContext().isPartialRequest()) {
            StringBuilder eval = new StringBuilder();
            String jsVar = this.resolveWidgetVar();
            eval.append("PF('").append(jsVar).append("')").append(".clearDataInput();");
            PrimeFaces.current().executeScript(eval.toString());
        }
    }

    public String getInvalidDataValue() {
        JavascriptVarBuilder vb = new JavascriptVarBuilder(null, true);
        for (SheetInvalidUpdate sheetInvalidUpdate : this.getInvalidUpdates()) {
            Object rowKey = sheetInvalidUpdate.getInvalidRowKey();
            int col = this.getRenderIndexFromRealIdx(sheetInvalidUpdate.getInvalidColIndex());
            String rowKeyProperty = this.getRowKeyValueAsString(rowKey);
            vb.appendProperty(rowKeyProperty + "_c" + col, sheetInvalidUpdate.getInvalidMessage().replace("'", "&apos;"), true);
        }
        return vb.closeVar().toString();
    }

    public void renderRowUpdateScript(FacesContext context, Set<String> dirtyRows) {
        String jsVar = this.resolveWidgetVar();
        StringBuilder eval = new StringBuilder();
        for (String rowKey : dirtyRows) {
            this.setRowVar(context, rowKey);
            int rowIndex = this.rowNumbers.get(rowKey);
            JavascriptVarBuilder jsRow = new JavascriptVarBuilder(null, false);
            JavascriptVarBuilder jsStyle = new JavascriptVarBuilder(null, true);
            JavascriptVarBuilder jsReadOnly = new JavascriptVarBuilder(null, true);
            int renderCol = 0;
            for (int col = 0; col < this.getColumns().size(); ++col) {
                boolean readOnly;
                SheetColumn column = this.getColumns().get(col);
                if (!column.isRendered()) continue;
                String value = this.getRenderValueForCell(context, rowKey, col);
                jsRow.appendArrayValue(value, true);
                String styleClass = column.getStyleClass();
                if (styleClass != null) {
                    jsStyle.appendRowColProperty(rowIndex, renderCol, styleClass, true);
                }
                if (readOnly = column.isReadonlyCell()) {
                    jsReadOnly.appendRowColProperty(rowIndex, renderCol, "true", true);
                }
                ++renderCol;
            }
            eval.append("PF('").append(jsVar).append("')");
            eval.append(".updateData('");
            eval.append(rowIndex);
            eval.append("',");
            eval.append(jsRow.closeVar().toString());
            eval.append(",");
            eval.append(jsStyle.closeVar().toString());
            eval.append(",");
            eval.append(jsReadOnly.closeVar().toString());
            eval.append(");");
        }
        eval.append("PF('").append(jsVar).append("')").append(".redraw();");
        PrimeFaces.current().executeScript(eval.toString());
    }

    public void renderBadUpdateScript() {
        String widgetVar = this.resolveWidgetVar();
        String invalidValue = this.getInvalidDataValue();
        StringBuilder sb = new StringBuilder("PF('" + widgetVar + "')");
        sb.append(".cfg.errors=");
        sb.append(invalidValue);
        sb.append(";");
        sb.append("PF('").append(widgetVar).append("')");
        sb.append(".ht.render();");
        PrimeFaces.current().executeScript(sb.toString());
        sb = new StringBuilder();
        sb.append("PF('").append(widgetVar).append("')");
        sb.append(".sheetDiv.removeClass('ui-state-error')");
        if (!this.getInvalidUpdates().isEmpty()) {
            sb.append(".addClass('ui-state-error')");
        }
        PrimeFaces.current().executeScript(sb.toString());
    }

    public void appendUpdateEvent(Object rowKey, int colIndex, Object rowData, Object oldValue, Object newValue) {
        this.updates.add(new SheetUpdate(rowKey, colIndex, rowData, oldValue, newValue));
    }
}

