/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.model.mongo;

import dev.morphia.Datastore;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Query;
import dev.morphia.query.Sort;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.experimental.filters.Filters;
import dev.morphia.query.experimental.filters.RegexFilter;
import jakarta.faces.FacesException;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SortMeta;
import org.primefaces.util.Lazy;
import org.primefaces.util.SerializableSupplier;

public class MorphiaLazyDataModel<T>
extends LazyDataModel<T>
implements Serializable {
    protected Class<T> entityClass;
    protected SerializableSupplier<Datastore> ds;
    protected String rowKeyField;
    private transient Lazy<Method> rowKeyGetter;
    private final Map<String, BiConsumer<Query<T>, FilterMeta>> overrides = new HashMap<String, BiConsumer<Query<T>, FilterMeta>>();
    private transient Consumer<Query<T>> prependConsumer;
    private transient BiConsumer<Query<T>, FilterMeta> globalFilterConsumer;

    public MorphiaLazyDataModel() {
    }

    public MorphiaLazyDataModel(Class<T> entityClass, SerializableSupplier<Datastore> ds, String rowKeyField) {
        this();
        this.ds = ds;
        this.entityClass = entityClass;
        this.rowKeyField = rowKeyField;
    }

    public MorphiaLazyDataModel(Class<T> entityClass, SerializableSupplier<Datastore> ds) {
        this(entityClass, ds, "id");
    }

    public T getRowData(String rowKey) {
        if (this.rowKeyField != null) {
            for (Object object : this.getWrappedData()) {
                try {
                    Object rko = this.getRowKeyGetter().invoke(object, new Object[0]);
                    String rk = rko == null ? null : rko.toString();
                    if (!Objects.equals(rk, rowKey)) continue;
                    return (T)object;
                }
                catch (Exception ex) {
                    throw new FacesException("Could not invoke getter for " + this.rowKeyField + " on " + this.entityClass.getName(), (Throwable)ex);
                }
            }
            return null;
        }
        throw new UnsupportedOperationException(this.getMessage("Provide a Converter or rowKeyField via constructor or implement getRowData(String rowKey) in %s, when basic rowKey algorithm is not used [component=%s,view=%s]."));
    }

    public String getRowKey(T object) {
        if (this.rowKeyField != null) {
            try {
                Object rowKey = this.getRowKeyGetter().invoke(object, new Object[0]);
                return rowKey == null ? null : rowKey.toString();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new FacesException("Could not invoke getter for " + this.rowKeyField + " on " + this.entityClass.getName(), (Throwable)e);
            }
        }
        throw new UnsupportedOperationException(this.getMessage("Provide a Converter or rowKeyField via constructor or implement getRowKey(T object) in %s, when basic rowKey algorithm is not used [component=%s,view=%s]."));
    }

    public int count(Map<String, FilterMeta> map) {
        Query<T> q = this.buildQuery();
        long count = this.applyFilters(q, map).count();
        return (int)count;
    }

    public List<T> load(int first, int pageSize, Map<String, SortMeta> sort, Map<String, FilterMeta> filters) {
        Query<T> q = this.buildQuery();
        FindOptions opt = new FindOptions();
        sort.forEach((field, sortData) -> opt.sort(new Sort[]{sortData.getOrder().name().equalsIgnoreCase("DESCENDING") ? Sort.descending((String)field) : Sort.ascending((String)field)}));
        this.applyFilters(q, filters);
        opt.skip(first).limit(pageSize);
        return q.iterator(opt).toList();
    }

    public Query<T> applyFilters(Query<T> q, Map<String, FilterMeta> filters) {
        filters.forEach((field, metadata) -> {
            if (metadata.getFilterValue() != null) {
                BiConsumer<Query<Query>, FilterMeta> override = this.overrides.get(field);
                if (override != null) {
                    override.accept((Query<Query>)q, (FilterMeta)metadata);
                } else {
                    Object val = metadata.getFilterValue();
                    if (metadata.getMatchMode() != null) {
                        switch (metadata.getMatchMode()) {
                            case STARTS_WITH: {
                                RegexFilter regStartsWith = Filters.regex((String)field);
                                regStartsWith.pattern("^" + val).caseInsensitive();
                                q.filter(new Filter[]{regStartsWith});
                                break;
                            }
                            case ENDS_WITH: {
                                RegexFilter regEndsWith = Filters.regex((String)field);
                                regEndsWith.pattern(val + "$").caseInsensitive();
                                q.filter(new Filter[]{regEndsWith});
                                break;
                            }
                            case CONTAINS: {
                                q.filter(new Filter[]{Filters.regex((String)field).pattern(val + "").caseInsensitive()});
                                break;
                            }
                            case EXACT: {
                                Object castedValueEx = this.castedValue((String)field, val);
                                if (castedValueEx != null) {
                                    q.filter(new Filter[]{Filters.eq((String)field, (Object)castedValueEx)});
                                    break;
                                }
                                q.filter(new Filter[]{Filters.eq((String)field, (Object)val)});
                                break;
                            }
                            case LESS_THAN: {
                                Object castedValueLt = this.castedValue((String)field, val);
                                if (castedValueLt != null) {
                                    q.filter(new Filter[]{Filters.lt((String)field, (Object)castedValueLt)});
                                    break;
                                }
                                q.filter(new Filter[]{Filters.lt((String)field, (Object)val)});
                                break;
                            }
                            case LESS_THAN_EQUALS: {
                                Object castedValueLte = this.castedValue((String)field, val);
                                if (castedValueLte != null) {
                                    q.filter(new Filter[]{Filters.lte((String)field, (Object)castedValueLte)});
                                    break;
                                }
                                q.filter(new Filter[]{Filters.lte((String)field, (Object)val)});
                                break;
                            }
                            case GREATER_THAN: {
                                Object castedValueGt = this.castedValue((String)field, val);
                                if (castedValueGt != null) {
                                    q.filter(new Filter[]{Filters.gt((String)field, (Object)castedValueGt)});
                                    break;
                                }
                                q.filter(new Filter[]{Filters.gt((String)field, (Object)val)});
                                break;
                            }
                            case GREATER_THAN_EQUALS: {
                                Object castedValueGte = this.castedValue((String)field, val);
                                if (castedValueGte != null) {
                                    q.filter(new Filter[]{Filters.gte((String)field, (Object)castedValueGte)});
                                    break;
                                }
                                q.filter(new Filter[]{Filters.gte((String)field, (Object)val)});
                                break;
                            }
                            case EQUALS: {
                                q.filter(new Filter[]{Filters.eq((String)field, (Object)val)});
                                break;
                            }
                            case IN: {
                                if (metadata.getFilterValue().getClass() != Object[].class) break;
                                Object[] parts = (Object[])metadata.getFilterValue();
                                q.filter(new Filter[]{Filters.in((String)field, Arrays.asList(parts))});
                                break;
                            }
                            case BETWEEN: {
                                List dates;
                                if (!(metadata.getFilterValue() instanceof List) || (dates = (List)metadata.getFilterValue()).size() <= 1) break;
                                q.filter(new Filter[]{Filters.gte((String)field, dates.get(0)), Filters.lte((String)field, dates.get(1))});
                                break;
                            }
                            case NOT_CONTAINS: {
                                q.filter(new Filter[]{Filters.regex((String)field).pattern(val + "").caseInsensitive().not()});
                                break;
                            }
                            case NOT_EQUALS: {
                                Object castedValueNe = this.castedValue((String)field, val);
                                if (castedValueNe != null) {
                                    q.filter(new Filter[]{Filters.eq((String)field, (Object)castedValueNe).not()});
                                    break;
                                }
                                q.filter(new Filter[]{Filters.eq((String)field, (Object)val).not()});
                                break;
                            }
                            case NOT_STARTS_WITH: {
                                RegexFilter regStartsWithNot = Filters.regex((String)field);
                                regStartsWithNot.pattern("^" + val).caseInsensitive();
                                q.filter(new Filter[]{regStartsWithNot.not()});
                                break;
                            }
                            case NOT_IN: {
                                if (!(metadata.getFilterValue() instanceof Object[])) break;
                                Object[] parts = (Object[])metadata.getFilterValue();
                                q.filter(new Filter[]{Filters.nin((String)field, Arrays.asList(parts))});
                                break;
                            }
                            case NOT_ENDS_WITH: {
                                RegexFilter regEndsWithNot = Filters.regex((String)field);
                                regEndsWithNot.pattern(val + "$").caseInsensitive();
                                q.filter(new Filter[]{regEndsWithNot.not()});
                                break;
                            }
                            case GLOBAL: {
                                if (this.globalFilterConsumer == null) break;
                                this.globalFilterConsumer.accept((Query<Query>)q, (FilterMeta)metadata);
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("MatchMode " + metadata.getMatchMode() + " not supported");
                            }
                        }
                    }
                }
            }
        });
        return q;
    }

    public MorphiaLazyDataModel<T> prependQuery(Consumer<Query<T>> consumer) {
        this.prependConsumer = consumer;
        return this;
    }

    public MorphiaLazyDataModel<T> globalFilter(BiConsumer<Query<T>, FilterMeta> consumer) {
        this.globalFilterConsumer = consumer;
        return this;
    }

    public MorphiaLazyDataModel<T> overrideFieldQuery(String field, BiConsumer<Query<T>, FilterMeta> consumer) {
        this.overrides.put(field, consumer);
        return this;
    }

    protected Method getRowKeyGetter() {
        if (this.rowKeyGetter == null) {
            this.rowKeyGetter = new Lazy((SerializableSupplier & Serializable)() -> {
                try {
                    return new PropertyDescriptor(this.rowKeyField, this.entityClass).getReadMethod();
                }
                catch (IntrospectionException e) {
                    throw new FacesException("Could not access " + this.rowKeyField + " on " + this.entityClass.getName(), (Throwable)e);
                }
            });
        }
        return (Method)this.rowKeyGetter.get();
    }

    private Object castedValue(String field, Object value) {
        try {
            Field f = this.entityClass.getDeclaredField(field);
            if (f == null) {
                return null;
            }
            if (f.getType().isAssignableFrom(Integer.class) || f.getType().isAssignableFrom(Integer.TYPE)) {
                return Integer.valueOf(value + "");
            }
            if (f.getType().isAssignableFrom(Float.class) || f.getType().isAssignableFrom(Float.TYPE)) {
                return Float.valueOf(value + "");
            }
            if (f.getType().isAssignableFrom(Double.class) || f.getType().isAssignableFrom(Double.TYPE)) {
                return Double.valueOf(value + "");
            }
            if (f.getType().isAssignableFrom(Long.class) || f.getType().isAssignableFrom(Long.TYPE)) {
                return Long.valueOf(value + "");
            }
            if (f.getType().isAssignableFrom(Boolean.class) || f.getType().isAssignableFrom(Boolean.TYPE)) {
                return Boolean.valueOf(value + "");
            }
            if (f.getType().isAssignableFrom(String.class)) {
                return value + "";
            }
        }
        catch (Exception e) {
            throw new FacesException("Failed to convert " + field + " to its corresponding data type", (Throwable)e);
        }
        return null;
    }

    private Query<T> buildQuery() {
        Query q = ((Datastore)this.ds.get()).find(this.entityClass).disableValidation();
        if (this.prependConsumer != null) {
            this.prependConsumer.accept(q);
        }
        return q;
    }
}

