/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.ckeditor;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.primefaces.extensions.component.ckeditor.CKEditor;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;

public class CKEditorRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        CKEditor ckEditor = (CKEditor)component;
        if (!this.shouldDecode((UIInput)ckEditor)) {
            return;
        }
        String clientId = ckEditor.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId)) {
            ckEditor.setSubmittedValue(params.get(clientId));
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        CKEditor ckEditor = (CKEditor)component;
        this.encodeMarkup(context, ckEditor);
        this.encodeScript(context, ckEditor);
    }

    protected void encodeMarkup(FacesContext context, CKEditor ckEditor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ckEditor.getClientId(context);
        writer.startElement("textarea", (UIComponent)ckEditor);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        if (ckEditor.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)ckEditor.getTabindex(), null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)ckEditor);
        this.renderPassThruAttributes(context, (UIComponent)ckEditor, HTML.TEXTAREA_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)ckEditor, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)ckEditor);
        String valueToRender = ComponentUtils.getValueToRender((FacesContext)context, (UIComponent)ckEditor);
        if (valueToRender != null) {
            if (ckEditor.isEscape()) {
                writer.writeText((Object)valueToRender, null);
            } else {
                writer.write(valueToRender);
            }
        }
        writer.endElement("textarea");
    }

    protected void encodeScript(FacesContext context, CKEditor ckEditor) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtCKEditor", (UIComponent)ckEditor);
        wb.attr("height", ckEditor.getHeight()).attr("width", ckEditor.getWidth()).attr("skin", ckEditor.getSkin()).attr("toolbar", ckEditor.getToolbar()).attr("readOnly", Boolean.valueOf(ckEditor.isReadonly())).attr("interfaceColor", ckEditor.getInterfaceColor()).attr("language", ckEditor.getLanguage()).attr("defaultLanguage", ckEditor.getDefaultLanguage()).attr("customConfig", ckEditor.getCustomConfig()).attr("advancedContentFilter", Boolean.valueOf(ckEditor.isAdvancedContentFilter())).attr("disableNativeSpellChecker", Boolean.valueOf(ckEditor.isDisableNativeSpellChecker())).attr("tabindex", ckEditor.getTabindex()).attr("placeholder", ckEditor.getPlaceholder()).attr("font", ckEditor.getFont()).attr("fontSize", ckEditor.getFontSize()).attr("enterMode", ckEditor.getEnterMode()).attr("shiftEnterMode", ckEditor.getShiftEnterMode()).attr("fileBrowserUploadUrl", ckEditor.getFileBrowserUploadUrl());
        if (ckEditor.getContentsCss() != null && ckEditor.getContentsCss().startsWith("[")) {
            wb.nativeAttr("contentsCss", ckEditor.getContentsCss());
        } else {
            wb.attr("contentsCss", ckEditor.getContentsCss());
        }
        this.encodeClientBehaviors(context, ckEditor);
        wb.finish();
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) {
        CKEditor ckEditor = (CKEditor)component;
        String value = (String)submittedValue;
        Converter converter = ComponentUtils.getConverter((FacesContext)context, (UIComponent)component);
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)ckEditor, value);
        }
        return value;
    }
}

