/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.converter;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.FacesConverter;
import org.primefaces.extensions.util.ExtLangUtils;
import org.primefaces.extensions.util.json.GsonConverter;
import org.primefaces.extensions.util.json.ParameterizedTypeImpl;

@FacesConverter(value="org.primefaces.extensions.converter.JsonConverter")
public class JsonConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 20121214L;
    private static final Map<String, Class<?>> PRIMITIVE_CLASSES = new HashMap();
    private static final Map<String, Class<?>> PRIMITIVE_ARRAY_CLASSES = new HashMap();
    private String type;

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        Type objType;
        if (this.getType() == null) {
            ValueExpression expression = component.getValueExpression("value");
            objType = expression.getType(context.getELContext());
        } else {
            objType = this.getObjectType(this.getType().trim(), false);
        }
        return GsonConverter.getGson().fromJson(value, objType);
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (this.getType() == null) {
            return GsonConverter.getGson().toJson(value);
        }
        return GsonConverter.getGson().toJson(value, this.getObjectType(this.getType().trim(), false));
    }

    protected Type getObjectType(String type, boolean isTypeArg) {
        int commaPos;
        Class<?> rawType;
        Class<?> clazz = PRIMITIVE_CLASSES.get(type);
        if (clazz != null) {
            if (!isTypeArg) {
                return clazz;
            }
            throw new ConverterException(new FacesMessage(FacesMessage.SEVERITY_ERROR, "Type argument can not be a primitive type, but it was " + type + ".", ""));
        }
        clazz = PRIMITIVE_ARRAY_CLASSES.get(type);
        if (clazz != null) {
            return clazz;
        }
        int arrayBracketIdx = type.indexOf(91);
        int leftBracketIdx = type.indexOf(60);
        if (arrayBracketIdx >= 0 && (leftBracketIdx < 0 || arrayBracketIdx < leftBracketIdx)) {
            try {
                clazz = Class.forName(type.substring(0, arrayBracketIdx));
                return Array.newInstance(clazz, 0).getClass();
            }
            catch (ClassNotFoundException e) {
                throw this.notFoundException(type.substring(0, arrayBracketIdx));
            }
        }
        if (leftBracketIdx < 0) {
            try {
                return Class.forName(type);
            }
            catch (ClassNotFoundException e) {
                throw this.notFoundException(type);
            }
        }
        int rightBracketIdx = type.lastIndexOf(62);
        if (rightBracketIdx < 0) {
            throw new ConverterException(new FacesMessage(FacesMessage.SEVERITY_ERROR, type + " is not a valid generic type.", ""));
        }
        try {
            rawType = Class.forName(type.substring(0, leftBracketIdx));
        }
        catch (ClassNotFoundException e) {
            throw this.notFoundException(type.substring(0, leftBracketIdx));
        }
        String strTypeArgs = type.substring(leftBracketIdx + 1, rightBracketIdx);
        ArrayList<String> listTypeArgs = new ArrayList<String>();
        int startPos = 0;
        int seekPos = 0;
        while ((commaPos = strTypeArgs.indexOf(44, seekPos)) >= 0) {
            int countRightBrackets;
            String term = strTypeArgs.substring(startPos, commaPos);
            int countLeftBrackets = ExtLangUtils.countMatches(term, '<');
            if (countLeftBrackets == (countRightBrackets = ExtLangUtils.countMatches(term, '>'))) {
                listTypeArgs.add(term.trim());
                startPos = commaPos + 1;
            }
            seekPos = commaPos + 1;
        }
        listTypeArgs.add(strTypeArgs.substring(startPos).trim());
        if (listTypeArgs.isEmpty()) {
            throw new ConverterException(new FacesMessage(FacesMessage.SEVERITY_ERROR, type + " is not a valid generic type.", ""));
        }
        int size = listTypeArgs.size();
        Type[] objectTypes = new Type[size];
        for (int i = 0; i < size; ++i) {
            objectTypes[i] = this.getObjectType((String)listTypeArgs.get(i), true);
        }
        return new ParameterizedTypeImpl(rawType, objectTypes, null);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    private ConverterException notFoundException(String classType) {
        return new ConverterException(new FacesMessage(FacesMessage.SEVERITY_ERROR, "Class " + classType + " not found", ""));
    }

    static {
        PRIMITIVE_CLASSES.put("boolean", Boolean.TYPE);
        PRIMITIVE_CLASSES.put("byte", Byte.TYPE);
        PRIMITIVE_CLASSES.put("short", Short.TYPE);
        PRIMITIVE_CLASSES.put("char", Character.TYPE);
        PRIMITIVE_CLASSES.put("int", Integer.TYPE);
        PRIMITIVE_CLASSES.put("long", Long.TYPE);
        PRIMITIVE_CLASSES.put("float", Float.TYPE);
        PRIMITIVE_CLASSES.put("double", Double.TYPE);
        PRIMITIVE_ARRAY_CLASSES.put("boolean[]", boolean[].class);
        PRIMITIVE_ARRAY_CLASSES.put("byte[]", byte[].class);
        PRIMITIVE_ARRAY_CLASSES.put("short[]", short[].class);
        PRIMITIVE_ARRAY_CLASSES.put("char[]", char[].class);
        PRIMITIVE_ARRAY_CLASSES.put("int[]", int[].class);
        PRIMITIVE_ARRAY_CLASSES.put("long[]", long[].class);
        PRIMITIVE_ARRAY_CLASSES.put("float[]", float[].class);
        PRIMITIVE_ARRAY_CLASSES.put("double[]", double[].class);
    }
}

