/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.application;

import java.util.Arrays;
import java.util.List;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.lifecycle.ClientWindow;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.primefaces.clientwindow.PrimeClientWindow;
import org.primefaces.clientwindow.PrimeClientWindowUtils;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.config.PrimeEnvironment;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.util.LocaleUtils;

public class PrimeFacesScriptProcessor
implements SystemEventListener {
    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        boolean shouldDiscard = Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(element -> "org.apache.myfaces.lifecycle.RestoreViewExecutor".equals(element.getClassName()));
        if (shouldDiscard) {
            return;
        }
        FacesContext context = event.getFacesContext();
        StringBuilder script = new StringBuilder(4000);
        this.encodeSettingScripts(context, script);
        this.encodeInitScripts(context, script);
        this.addJS(context, script.toString());
    }

    protected void encodeSettingScripts(FacesContext context, StringBuilder writer) {
        ClientWindow clientWindow;
        PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance((FacesContext)context);
        PrimeApplicationContext applicationContext = requestContext.getApplicationContext();
        PrimeConfiguration configuration = applicationContext.getConfig();
        ProjectStage projectStage = context.getApplication().getProjectStage();
        writer.append("if(window.PrimeFaces){");
        writer.append("PrimeFaces.settings.locale='").append(LocaleUtils.getCurrentLocale((FacesContext)context)).append("';");
        writer.append("PrimeFaces.settings.viewId='").append(context.getViewRoot().getViewId()).append("';");
        writer.append("PrimeFaces.settings.contextPath='").append(context.getExternalContext().getRequestContextPath()).append("';");
        writer.append("PrimeFaces.settings.cookiesSecure=").append(requestContext.isSecure() && configuration.isCookiesSecure()).append(";");
        if (applicationContext.getConfig().getCookiesSameSite() != null) {
            writer.append("PrimeFaces.settings.cookiesSameSite='").append(configuration.getCookiesSameSite()).append("';");
        }
        if (configuration.isClientSideValidationEnabled()) {
            writer.append("PrimeFaces.settings.validateEmptyFields=").append(configuration.isValidateEmptyFields()).append(";");
            writer.append("PrimeFaces.settings.considerEmptyStringNull=").append(configuration.isInterpretEmptyStringAsNull()).append(";");
        }
        if (configuration.isLegacyWidgetNamespace()) {
            writer.append("PrimeFaces.settings.legacyWidgetNamespace=true;");
        }
        if (configuration.isEarlyPostParamEvaluation()) {
            writer.append("PrimeFaces.settings.earlyPostParamEvaluation=true;");
        }
        if (configuration.isPartialSubmitEnabled()) {
            writer.append("PrimeFaces.settings.partialSubmit=true;");
        }
        if (projectStage != ProjectStage.Production) {
            writer.append("PrimeFaces.settings.projectStage='").append(projectStage.toString()).append("';");
        }
        if (applicationContext.getEnvironment().isAtLeastJsf22() && context.getExternalContext().getClientWindow() != null && (clientWindow = context.getExternalContext().getClientWindow()) instanceof PrimeClientWindow) {
            boolean initialRedirect = false;
            Object cookie = PrimeClientWindowUtils.getInitialRedirectCookie((FacesContext)context, (String)clientWindow.getId());
            if (cookie instanceof Cookie) {
                Cookie servletCookie = (Cookie)cookie;
                initialRedirect = true;
                servletCookie.setMaxAge(0);
                ((HttpServletResponse)context.getExternalContext().getResponse()).addCookie(servletCookie);
            }
            writer.append(String.format("PrimeFaces.clientwindow.init('%s', %s);", PrimeClientWindowUtils.secureWindowId((String)clientWindow.getId()), initialRedirect));
        }
        writer.append("}");
    }

    protected void encodeInitScripts(FacesContext context, StringBuilder writer) {
        PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance((FacesContext)context);
        List scripts = requestContext.getInitScriptsToExecute();
        if (!scripts.isEmpty()) {
            boolean moveScriptsToBottom = requestContext.getApplicationContext().getConfig().isMoveScriptsToBottom();
            if (!moveScriptsToBottom) {
                writer.append("$(function(){");
            }
            for (String script : scripts) {
                writer.append(script);
                writer.append(';');
            }
            if (!moveScriptsToBottom) {
                writer.append("});");
            }
        }
    }

    private void addJS(FacesContext context, String script) {
        UIOutput js = new UIOutput();
        js.setRendererType("javax.faces.resource.Script");
        PrimeEnvironment environment = PrimeApplicationContext.getCurrentInstance((FacesContext)context).getEnvironment();
        if (!environment.isMojarra()) {
            js.setId("primfaces-script-processor");
        }
        UIOutput content = new UIOutput();
        content.setValue((Object)script);
        js.getChildren().add(content);
        context.getViewRoot().addComponentResource(context, (UIComponent)js);
    }
}

