/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.monacoeditor;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.primefaces.extensions.component.monacoeditor.MonacoEditorBase;
import org.primefaces.extensions.component.monacoeditor.MonacoEditorCommon;
import org.primefaces.extensions.component.monacoeditor.MonacoEditorCommonRenderer;
import org.primefaces.extensions.model.monacoeditor.EditorOptions;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

abstract class MonacoEditorBaseRenderer<TEditor extends MonacoEditorBase>
extends MonacoEditorCommonRenderer<TEditor, EditorOptions> {
    private static final String INPUT_SUFFIX = "_input";
    private static final List<String> PASSTHROUGH_ATTRS = Arrays.asList("alt", "accesskey", "autocomplete", "cols", "dir", "lang", "maxlength", "placeholder", "rows", "size", "title");

    protected MonacoEditorBaseRenderer(Class<TEditor> clazz) {
        super(clazz);
    }

    protected abstract void addWidgetProperties(FacesContext var1, WidgetBuilder var2, TEditor var3) throws IOException;

    public final void decode(FacesContext context, UIComponent component) {
        MonacoEditorBase monacoEditor = (MonacoEditorBase)((Object)this.componentClass.cast(component));
        if (monacoEditor.isDisabled()) {
            return;
        }
        String clientId = monacoEditor.getClientId() + INPUT_SUFFIX;
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId)) {
            monacoEditor.setSubmittedValue(params.get(clientId));
        }
        this.decodeBehaviors(context, component);
    }

    @Override
    protected final void encodeHiddenInput(FacesContext context, TEditor monacoEditor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = monacoEditor.getClientId();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("textarea", null);
        writer.writeAttribute("id", (Object)(clientId + INPUT_SUFFIX), null);
        writer.writeAttribute("name", (Object)(clientId + INPUT_SUFFIX), null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (monacoEditor.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (monacoEditor.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        this.renderPassThruAttributes(context, (UIComponent)monacoEditor, PASSTHROUGH_ATTRS);
        String valueToRender = ComponentUtils.getValueToRender((FacesContext)context, monacoEditor);
        if (valueToRender != null) {
            writer.writeText((Object)valueToRender, null);
        }
        writer.endElement("textarea");
        writer.endElement("div");
    }

    public final Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) {
        MonacoEditorBase monacoEditor = (MonacoEditorBase)((Object)this.componentClass.cast(component));
        String value = (String)submittedValue;
        Converter converter = ComponentUtils.getConverter((FacesContext)context, (UIComponent)monacoEditor);
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)monacoEditor, value);
        }
        return value;
    }

    @Override
    protected final void addBaseWidgetProperties(FacesContext context, WidgetBuilder wb, TEditor monacoEditor) throws IOException {
        this.addWidgetProperties(context, wb, monacoEditor);
    }

    @Override
    protected boolean isEntireEditorDisabled(TEditor monacoEditor) {
        return monacoEditor.isDisabled();
    }

    @Override
    protected String getLanguage(TEditor monacoEditor) {
        return ((EditorOptions)((MonacoEditorCommon)((Object)monacoEditor)).getEditorOptions()).getLanguage();
    }
}

