/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.codemirror;

import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.event.PhaseId;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.extensions.component.codemirror.CodeMirror;
import org.primefaces.extensions.event.CompleteEvent;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;

public class CodeMirrorRenderer
extends InputRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        CodeMirror codeMirror = (CodeMirror)component;
        if (!this.shouldDecode((UIInput)codeMirror)) {
            return;
        }
        String clientId = codeMirror.getClientId(facesContext);
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId)) {
            codeMirror.setSubmittedValue(params.get(clientId));
        }
        this.decodeBehaviors(facesContext, component);
        String token = (String)params.get(clientId + "_token");
        if (token != null) {
            String context = (String)params.get(clientId + "_context");
            int line = Integer.parseInt((String)params.get(clientId + "_line"));
            int column = Integer.parseInt((String)params.get(clientId + "_column"));
            CompleteEvent autoCompleteEvent = new CompleteEvent((UIComponent)codeMirror, token, context, line, column);
            autoCompleteEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            codeMirror.queueEvent(autoCompleteEvent);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        CodeMirror codeMirror = (CodeMirror)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        String token = (String)params.get(codeMirror.getClientId(context) + "_token");
        if (token != null) {
            this.encodeSuggestions(context, codeMirror, codeMirror.getSuggestions());
        } else {
            this.encodeMarkup(context, codeMirror);
            this.encodeScript(context, codeMirror);
        }
    }

    protected void encodeMarkup(FacesContext context, CodeMirror codeMirror) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = codeMirror.getClientId(context);
        writer.startElement("textarea", (UIComponent)codeMirror);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        this.renderAccessibilityAttributes(context, (UIInput)codeMirror);
        this.renderPassThruAttributes(context, (UIComponent)codeMirror, HTML.TEXTAREA_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)codeMirror, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)codeMirror, new ClientValidator[0]);
        String valueToRender = ComponentUtils.getValueToRender((FacesContext)context, (UIComponent)codeMirror);
        if (valueToRender != null) {
            if (codeMirror.isEscape()) {
                writer.writeText((Object)valueToRender, null);
            } else {
                writer.write(valueToRender);
            }
        }
        writer.endElement("textarea");
    }

    protected void encodeScript(FacesContext context, CodeMirror codeMirror) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtCodeMirror", (UIComponent)codeMirror);
        wb.attr("theme", codeMirror.getTheme()).attr("mode", codeMirror.getMode()).attr("indentUnit", (Number)codeMirror.getIndentUnit()).attr("smartIndent", codeMirror.isSmartIndent()).attr("tabSize", (Number)codeMirror.getTabSize()).attr("indentWithTabs", codeMirror.isIndentWithTabs()).attr("electricChars", codeMirror.isElectricChars()).attr("keyMap", codeMirror.getKeyMap()).attr("lineWrapping", codeMirror.isLineWrapping()).attr("lineNumbers", codeMirror.isLineNumbers()).attr("firstLineNumber", (Number)codeMirror.getFirstLineNumber()).attr("gutter", codeMirror.isGutter()).attr("fixedGutter", codeMirror.isFixedGutter()).attr("readOnly", Boolean.valueOf(codeMirror.isReadonly())).attr("matchBrackets", codeMirror.isMatchBrackets()).attr("workTime", (Number)codeMirror.getWorkTime()).attr("workDelay", (Number)codeMirror.getWorkDelay()).attr("pollInterval", (Number)codeMirror.getPollInterval()).attr("tabindex", codeMirror.getTabindex()).attr("undoDepth", (Number)codeMirror.getUndoDepth());
        if (codeMirror.getExtraKeys() != null) {
            wb.append(",extraKeys:" + codeMirror.getExtraKeys());
        }
        if (!codeMirror.isGlobal()) {
            wb.attr("global", Boolean.valueOf(false));
        }
        if (codeMirror.isAsync()) {
            wb.attr("async", Boolean.valueOf(true));
        }
        if (codeMirror.getProcess() != null) {
            wb.attr("process", SearchExpressionUtils.resolveClientIdsForClientSide((FacesContext)context, (UIComponent)codeMirror, (String)codeMirror.getProcess()));
        }
        if (codeMirror.getOnstart() != null) {
            wb.callback("onstart", "function(request)", codeMirror.getOnstart());
        }
        if (codeMirror.getOncomplete() != null) {
            wb.callback("oncomplete", "function(xhr, status, args)", codeMirror.getOncomplete());
        }
        if (codeMirror.getOnsuccess() != null) {
            wb.callback("onsuccess", "function(data, status, xhr)", codeMirror.getOnsuccess());
        }
        if (codeMirror.getOnerror() != null) {
            wb.callback("onerror", "function(xhr, status, error)", codeMirror.getOnerror());
        }
        this.encodeClientBehaviors(context, codeMirror);
        wb.finish();
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) {
        CodeMirror codeMirror = (CodeMirror)component;
        String value = (String)submittedValue;
        Converter converter = ComponentUtils.getConverter((FacesContext)context, (UIComponent)component);
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)codeMirror, value);
        }
        return value;
    }

    protected void encodeSuggestions(FacesContext context, CodeMirror codeMirror, List<String> suggestions) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("ul", (UIComponent)codeMirror);
        for (String suggestion : suggestions) {
            writer.startElement("li", null);
            if (codeMirror.isEscapeSuggestions()) {
                writer.writeText((Object)suggestion, null);
            } else {
                writer.write(suggestion);
            }
            writer.endElement("li");
        }
        writer.endElement("ul");
    }
}

