/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.gchart;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.gchart.GChart;
import org.primefaces.extensions.component.gchart.model.GChartModel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class GChartRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        GChart gChart = (GChart)component;
        this.encodeMarkup(context, gChart);
        this.encodeScript(context, gChart);
    }

    protected void encodeMarkup(FacesContext context, GChart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        this.renderHiddenInput(context, chart.getClientId() + "_hidden", null, false);
        writer.startElement("div", (UIComponent)chart);
        writer.writeAttribute("id", (Object)chart.getClientId(), null);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, GChart chart) throws IOException {
        String apiKey = chart.getApiKey();
        if (LangUtils.isBlank((String)apiKey)) {
            apiKey = this.getApiKey(context);
        }
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtGChart", (UIComponent)chart).attr("chart", ((GChartModel)chart.getValue()).toJson()).attr("title", chart.getTitle()).attr("apiKey", apiKey).attr("language", chart.getLanguage()).attr("width", (Number)chart.getWidth()).attr("height", (Number)chart.getHeight());
        if (chart.getExtender() != null) {
            wb.nativeAttr("extender", chart.getExtender());
        }
        this.encodeClientBehaviors(context, chart);
        wb.finish();
    }

    protected String getApiKey(FacesContext context) {
        String key;
        try {
            String initParam = context.getExternalContext().getInitParameter("primefaces.GOOGLE_MAPS_API_KEY");
            key = (String)context.getApplication().evaluateExpressionGet(context, initParam, String.class);
        }
        catch (Exception e) {
            key = null;
        }
        return key;
    }
}

