/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.monacoeditor;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.extensions.component.monacoeditor.MonacoDiffEditorBase;
import org.primefaces.extensions.component.monacoeditor.MonacoEditorCommon;
import org.primefaces.extensions.component.monacoeditor.MonacoEditorCommonRenderer;
import org.primefaces.extensions.model.monaco.MonacoDiffEditorModel;
import org.primefaces.extensions.model.monacoeditor.DiffEditorOptions;
import org.primefaces.util.WidgetBuilder;

abstract class MonacoDiffEditorBaseRenderer<TEditor extends MonacoDiffEditorBase>
extends MonacoEditorCommonRenderer<TEditor, DiffEditorOptions> {
    private static final String INPUT_SUFFIX = "_input";
    private static final String INPUT_ORIGINAL_SUFFIX = "_input_original";
    private static final List<String> PASSTHROUGH_ATTRS = Arrays.asList("alt", "accesskey", "autocomplete", "cols", "dir", "lang", "maxlength", "placeholder", "rows", "size", "title");

    protected MonacoDiffEditorBaseRenderer(Class<TEditor> clazz) {
        super(clazz);
    }

    public final void decode(FacesContext context, UIComponent component) {
        MonacoDiffEditorBase monacoEditor = (MonacoDiffEditorBase)((Object)this.componentClass.cast(component));
        String clientId = monacoEditor.getClientId() + INPUT_SUFFIX;
        String originalClientId = monacoEditor.getClientId() + INPUT_ORIGINAL_SUFFIX;
        Map params = context.getExternalContext().getRequestParameterMap();
        boolean update = false;
        String originalValue = null;
        String modifiedValue = null;
        if (!monacoEditor.isDisabled() && params.containsKey(clientId)) {
            modifiedValue = (String)params.get(clientId);
            update = true;
        }
        if (!monacoEditor.isOriginalDisabled() && params.containsKey(originalClientId)) {
            originalValue = (String)params.get(originalClientId);
            update = true;
        }
        if (update) {
            AbstractMap.SimpleEntry<Object, String> entry = new AbstractMap.SimpleEntry<Object, String>(originalValue, modifiedValue);
            monacoEditor.setSubmittedValue(entry);
        }
        this.decodeBehaviors(context, component);
    }

    @Override
    protected final void encodeHiddenInput(FacesContext context, TEditor monacoEditor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = monacoEditor.getClientId();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        this.renderPassThruAttributes(context, (UIComponent)monacoEditor, PASSTHROUGH_ATTRS);
        MonacoDiffEditorModel valueToRender = (MonacoDiffEditorModel)MonacoDiffEditorBaseRenderer.getValueToRender(context, monacoEditor);
        writer.startElement("textarea", null);
        writer.writeAttribute("id", (Object)(clientId + INPUT_SUFFIX), null);
        writer.writeAttribute("name", (Object)(clientId + INPUT_SUFFIX), null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (monacoEditor.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (monacoEditor.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (valueToRender != null && valueToRender.getModifiedValue() != null) {
            writer.writeText((Object)valueToRender.getModifiedValue(), null);
        }
        writer.endElement("textarea");
        writer.startElement("textarea", null);
        writer.writeAttribute("id", (Object)(clientId + INPUT_ORIGINAL_SUFFIX), null);
        writer.writeAttribute("name", (Object)(clientId + INPUT_ORIGINAL_SUFFIX), null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (((MonacoDiffEditorBase)((Object)monacoEditor)).isOriginalDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (((MonacoDiffEditorBase)((Object)monacoEditor)).isOriginalReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (valueToRender != null && valueToRender.getOriginalValue() != null) {
            writer.writeText((Object)valueToRender.getOriginalValue(), null);
        }
        writer.endElement("textarea");
        writer.endElement("div");
    }

    public final Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) {
        return MonacoDiffEditorBaseRenderer.convertedSubmittedValue(component, submittedValue);
    }

    @Override
    protected final void addBaseWidgetProperties(FacesContext context, WidgetBuilder wb, TEditor monacoEditor) throws IOException {
        wb.attr("originalDisabled", ((MonacoDiffEditorBase)((Object)monacoEditor)).isOriginalDisabled(), true);
        wb.attr("originalReadonly", ((MonacoDiffEditorBase)((Object)monacoEditor)).isOriginalReadonly(), false);
        wb.attr("originalLanguage", ((MonacoDiffEditorBase)((Object)monacoEditor)).getOriginalLanguage(), MonacoDiffEditorBase.DEFAULT_ORIGINAL_LANGUAGE);
        wb.attr("originalRequired", ((MonacoDiffEditorBase)((Object)monacoEditor)).isOriginalRequired(), false);
        wb.attr("originalScheme", ((MonacoEditorCommon)((Object)monacoEditor)).getScheme(), "inmemory");
        wb.attr("originalDirectory", ((MonacoEditorCommon)((Object)monacoEditor)).getDirectory(), "");
        wb.attr("originalBasename", ((MonacoEditorCommon)((Object)monacoEditor)).getBasename(), "");
        wb.attr("originalExtension", ((MonacoEditorCommon)((Object)monacoEditor)).getExtension(), "");
        wb.callback("onoriginalblur", "function()", ((MonacoDiffEditorBase)((Object)monacoEditor)).getOnoriginalblur());
        wb.callback("onoriginalchange", "function()", ((MonacoDiffEditorBase)((Object)monacoEditor)).getOnoriginalchange());
        wb.callback("onoriginalfocus", "function()", ((MonacoDiffEditorBase)((Object)monacoEditor)).getOnoriginalfocus());
        wb.callback("onoriginalkeyup", "function()", ((MonacoDiffEditorBase)((Object)monacoEditor)).getOnoriginalkeyup());
        wb.callback("onoriginalmousedown", "function()", ((MonacoDiffEditorBase)((Object)monacoEditor)).getOnoriginalmousedown());
        wb.callback("onoriginalmousemove", "function()", ((MonacoDiffEditorBase)((Object)monacoEditor)).getOnoriginalmousemove());
        wb.callback("onoriginalmouseup", "function()", ((MonacoDiffEditorBase)((Object)monacoEditor)).getOnoriginalmouseup());
        wb.callback("onoriginalkeydown", "function()", ((MonacoDiffEditorBase)((Object)monacoEditor)).getOnoriginalkeydown());
        wb.callback("onoriginalpaste", "function()", ((MonacoDiffEditorBase)((Object)monacoEditor)).getOnoriginalpaste());
        this.addWidgetProperties(context, wb, monacoEditor);
    }

    protected abstract void addWidgetProperties(FacesContext var1, WidgetBuilder var2, TEditor var3) throws IOException;

    @Override
    protected String getLanguage(TEditor monacoEditor) {
        return ((MonacoDiffEditorBase)((Object)monacoEditor)).getLanguage();
    }

    @Override
    protected boolean isEntireEditorDisabled(TEditor monacoEditor) {
        return monacoEditor.isDisabled() && ((MonacoDiffEditorBase)((Object)monacoEditor)).isOriginalDisabled();
    }

    private static Object getValueToRender(FacesContext context, MonacoDiffEditorBase component) {
        Object submittedValue = component.getSubmittedValue();
        PrimeConfiguration config = PrimeApplicationContext.getCurrentInstance((FacesContext)context).getConfig();
        if (config.isInterpretEmptyStringAsNull() && submittedValue == null && !component.isLocalValueSet() && context.isValidationFailed() && !component.isValid()) {
            return null;
        }
        if (submittedValue != null) {
            return MonacoDiffEditorBaseRenderer.convertedSubmittedValue((UIComponent)component, submittedValue);
        }
        Object value = component.getValue();
        return value instanceof MonacoDiffEditorModel ? (MonacoDiffEditorModel)value : MonacoDiffEditorModel.empty();
    }

    public static MonacoDiffEditorModel convertedSubmittedValue(UIComponent component, Object submittedValue) {
        if (submittedValue == null) {
            return MonacoDiffEditorModel.empty();
        }
        if (submittedValue instanceof MonacoDiffEditorModel) {
            return (MonacoDiffEditorModel)submittedValue;
        }
        MonacoDiffEditorBase editor = (MonacoDiffEditorBase)component;
        MonacoDiffEditorModel currentModel = editor.getValue() != null ? (MonacoDiffEditorModel)editor.getValue() : MonacoDiffEditorModel.empty();
        Map.Entry value = (Map.Entry)submittedValue;
        String originalValue = value.getKey() != null ? (String)value.getKey() : currentModel.getOriginalValue();
        String modifiedValue = value.getValue() != null ? (String)value.getValue() : currentModel.getModifiedValue();
        return new MonacoDiffEditorModel(originalValue, modifiedValue);
    }
}

