/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.cookiepolicy;

import jakarta.faces.component.UIComponentBase;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import org.primefaces.util.LangUtils;

public class CookiePolicy
extends UIComponentBase {
    public static final String COOKIE_POLICY_COOKIE_NAME = "CookiePolicy";
    public static final String COOKIE_POLICY_REQUEST_ATTRIBUTE = CookiePolicy.class.getName() + ".CookiePolicy";
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.CookiePolicy";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public boolean hasCookiePolicyCookie(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
        if (null != httpServletRequest.getAttribute(COOKIE_POLICY_REQUEST_ATTRIBUTE)) {
            return true;
        }
        return externalContext.getRequestCookieMap().containsKey(COOKIE_POLICY_COOKIE_NAME);
    }

    public static boolean hasCookiePolicy(String cookiePolicy) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
        String requestCookiePolicy = (String)httpServletRequest.getAttribute(COOKIE_POLICY_REQUEST_ATTRIBUTE);
        if (null != requestCookiePolicy) {
            return requestCookiePolicy.contains(cookiePolicy);
        }
        Cookie cookie = (Cookie)externalContext.getRequestCookieMap().get(COOKIE_POLICY_COOKIE_NAME);
        if (null == cookie) {
            return false;
        }
        String policy = cookie.getValue();
        if (LangUtils.isBlank((String)policy)) {
            return false;
        }
        return policy.contains(cookiePolicy);
    }
}

