
/*
 * Copyright (c) 2011-2022 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

/**
 * Options for whether unchanged regions should be hidden or visible.
 */
@SuppressWarnings("serial")
public class EditorHideUnchangedRegions extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorHideUnchangedRegions(this);
    }

    private static class SerializedEditorHideUnchangedRegions implements Serializable {
        private String json;

        public SerializedEditorHideUnchangedRegions(EditorHideUnchangedRegions editorHideUnchangedRegions) {
            this.json = editorHideUnchangedRegions.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorHideUnchangedRegions editorHideUnchangedRegions = new EditorHideUnchangedRegions();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorHideUnchangedRegions.put(key, value);
            }
            return editorHideUnchangedRegions;
        }
    }

    public Number getContextLineCount() {
        return (Number) (has("contextLineCount") ? get("contextLineCount") : null);
    }

    public EditorHideUnchangedRegions setContextLineCount(final Number contextLineCount) {
        put("contextLineCount", contextLineCount);
        return this;
    }

    public Boolean isEnabled() {
        return (Boolean) (has("enabled") ? get("enabled") : null);
    }

    public EditorHideUnchangedRegions setEnabled(final Boolean enabled) {
        put("enabled", enabled);
        return this;
    }

    public Number getMinimumLineCount() {
        return (Number) (has("minimumLineCount") ? get("minimumLineCount") : null);
    }

    public EditorHideUnchangedRegions setMinimumLineCount(final Number minimumLineCount) {
        put("minimumLineCount", minimumLineCount);
        return this;
    }

    public Number getRevealLineCount() {
        return (Number) (has("revealLineCount") ? get("revealLineCount") : null);
    }

    public EditorHideUnchangedRegions setRevealLineCount(final Number revealLineCount) {
        put("revealLineCount", revealLineCount);
        return this;
    }

    /**
     * @return This options object as a serializable JSON object
     */
    JSONObject getJSONObject() {
        return this;
    }
}