/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.inputplace;

import java.io.IOException;
import java.util.Locale;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.inputplace.InputPlace;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;

public class InputPlaceRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        InputPlace inputPlace = (InputPlace)component;
        if (!this.shouldDecode((UIInput)inputPlace)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputPlace);
        String clientId = inputPlace.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        if (submittedValue != null) {
            int maxlength = inputPlace.getMaxlength();
            if (maxlength > 0 && submittedValue.length() > maxlength) {
                submittedValue = LangUtils.substring((String)submittedValue, (int)0, (int)maxlength);
            }
            inputPlace.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputPlace inputPlace = (InputPlace)component;
        this.encodeMarkup(context, inputPlace);
        this.encodeScript(context, inputPlace);
    }

    protected void encodeScript(FacesContext context, InputPlace inputPlace) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtInputPlace", (UIComponent)inputPlace).attr("apiType", inputPlace.getApiType().toLowerCase(Locale.ROOT)).attr("apiKey", inputPlace.getApiKey(), null).attr("restrictTypes", inputPlace.getRestrictTypes(), null).attr("restrictCountries", inputPlace.getRestrictCountries(), null).callback("onPlaceChanged", "function(place)", inputPlace.getOnplacechanged());
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)inputPlace);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, InputPlace inputPlace) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputPlace.getClientId(context);
        writer.startElement("input", (UIComponent)inputPlace);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"text", null);
        String valueToRender = ComponentUtils.getValueToRender((FacesContext)context, (UIComponent)inputPlace);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        if (inputPlace.getStyle() != null) {
            writer.writeAttribute("style", (Object)inputPlace.getStyle(), null);
        }
        writer.writeAttribute("class", (Object)this.createStyleClass((UIInput)inputPlace, "ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all"), "styleClass");
        this.renderAccessibilityAttributes(context, (UIInput)inputPlace);
        this.renderRTLDirection(context, (UIComponent)inputPlace);
        this.renderPassThruAttributes(context, (UIComponent)inputPlace, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)inputPlace, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)inputPlace, new ClientValidator[0]);
        writer.endElement("input");
    }
}

