/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.tooltip;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.extensions.component.tooltip.Tooltip;
import org.primefaces.extensions.util.ComponentUtils;
import org.primefaces.extensions.util.FastStringWriter;
import org.primefaces.renderkit.CoreRenderer;

public class TooltipRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Tooltip tooltip = (Tooltip)component;
        String clientId = tooltip.getClientId(context);
        String widgetVar = tooltip.resolveWidgetVar();
        boolean global = tooltip.isGlobal();
        boolean shared = tooltip.isShared();
        boolean autoShow = tooltip.isAutoShow();
        boolean mouseTracking = tooltip.isMouseTracking();
        String target = null;
        if (!global || tooltip.getFor() != null) {
            target = SearchExpressionFacade.resolveClientIds((FacesContext)context, (UIComponent)tooltip, (String)tooltip.getFor());
        }
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('ExtTooltip', '" + widgetVar + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",widgetVar:'" + widgetVar + "'");
        writer.write(",global:" + global);
        writer.write(",shared:" + shared);
        writer.write(",autoShow:" + autoShow);
        if (target == null) {
            writer.write(",forTarget:null");
        } else {
            writer.write(",forTarget:'" + target + "'");
        }
        if (!global) {
            writer.write(",content:\"");
            if (tooltip.getChildCount() > 0) {
                FastStringWriter fsw = new FastStringWriter();
                ResponseWriter clonedWriter = writer.cloneWithWriter((Writer)fsw);
                context.setResponseWriter(clonedWriter);
                this.renderChildren(context, (UIComponent)tooltip);
                context.setResponseWriter(writer);
                writer.write(this.escapeText(fsw.toString()));
            } else {
                String valueToRender = ComponentUtils.getValueToRender((FacesContext)context, (UIComponent)tooltip);
                if (valueToRender != null) {
                    writer.write(this.escapeText(valueToRender));
                }
            }
            writer.write("\"");
        }
        if (mouseTracking) {
            writer.write(",hide:{fixed:true}");
        } else if (shared && !global) {
            writer.write(",show:{target:PrimeFaces.expressions.SearchExpressionFacade.resolveComponentsAsSelector('" + target + "')" + ",delay:" + tooltip.getShowDelay() + ",effect:function(){$(this)." + tooltip.getShowEffect() + "(" + tooltip.getShowEffectLength() + ");}}");
            writer.write(",hide:{target:PrimeFaces.expressions.SearchExpressionFacade.resolveComponentsAsSelector('" + target + "')" + ",delay:" + tooltip.getHideDelay() + ",fixed:" + tooltip.isFixed() + ",effect:function(){$(this)." + tooltip.getHideEffect() + "(" + tooltip.getHideEffectLength() + ");}}");
        } else if (autoShow) {
            writer.write(",show:{when:false,ready:true}");
            writer.write(",hide:false");
        } else {
            writer.write(",show:{event:'" + tooltip.getShowEvent() + "',delay:" + tooltip.getShowDelay() + ",effect:function(){$(this)." + tooltip.getShowEffect() + "(" + tooltip.getShowEffectLength() + ");}}");
            writer.write(",hide:{event:'" + tooltip.getHideEvent() + "',delay:" + tooltip.getHideDelay() + ",fixed:" + tooltip.isFixed() + ",effect:function(){$(this)." + tooltip.getHideEffect() + "(" + tooltip.getHideEffectLength() + ");}}");
        }
        writer.write(",position: {");
        writer.write("at:'" + tooltip.getAtPosition() + "'");
        writer.write(",my:'" + tooltip.getMyPosition() + "'");
        writer.write(",adjust:{x:" + tooltip.getAdjustX() + ",y:" + tooltip.getAdjustY() + "}");
        writer.write(",viewport:$(window)");
        if (mouseTracking) {
            writer.write(",target:'mouse'");
        } else if (shared && !global) {
            writer.write(",target:'event'");
            writer.write(",effect:false");
        }
        writer.write("}},true);});");
        this.endScript(writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

