/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.dynaform;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.faces.component.ContextCallback;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.component.api.InputHolder;
import org.primefaces.component.row.Row;
import org.primefaces.extensions.component.dynaform.DynaForm;
import org.primefaces.extensions.component.dynaform.UIDynaFormControl;
import org.primefaces.extensions.model.dynaform.AbstractDynaFormElement;
import org.primefaces.extensions.model.dynaform.DynaFormControl;
import org.primefaces.extensions.model.dynaform.DynaFormLabel;
import org.primefaces.extensions.model.dynaform.DynaFormModel;
import org.primefaces.extensions.model.dynaform.DynaFormModelElement;
import org.primefaces.extensions.model.dynaform.DynaFormRow;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.CompositeUtils;
import org.primefaces.util.WidgetBuilder;

public class DynaFormRenderer
extends CoreRenderer {
    private static final Logger LOGGER = Logger.getLogger(DynaFormRenderer.class.getName());
    private static final String FACET_HEADER_REGULAR = "headerRegular";
    private static final String FACET_FOOTER_REGULAR = "footerRegular";
    private static final String FACET_HEADER_EXTENDED = "headerExtended";
    private static final String FACET_FOOTER_EXTENDED = "footerExtended";
    private static final String FACET_BUTTON_BAR = "buttonBar";
    private static final String FACET_STATIC_TOP = "staticTop";
    private static final String FACET_STATIC_BOTTOM = "staticBottom";
    private static final String GRID_CLASS = "pe-dynaform-grid";
    private static final String NESTED_GRID_CLASS = "pe-dynaform-nested-grid";
    private static final String CELL_CLASS = "pe-dynaform-cell";
    private static final String CELL_FIRST_CLASS = "pe-dynaform-cell-first";
    private static final String CELL_LAST_CLASS = "pe-dynaform-cell-last";
    private static final String LABEL_CLASS = "pe-dynaform-label";
    private static final String LABEL_INVALID_CLASS = "ui-state-error ui-corner-all";
    private static final String LABEL_INDICATOR_CLASS = "pe-dynaform-label-rfi";
    private static final String LABEL_CONTROL_TYPE_CLASS_FORMAT = "pe-dynaform-%s-label";
    private static final String FACET_BUTTON_BAR_TOP_CLASS = "pe-dynaform-buttonbar-top";
    private static final String FACET_BUTTON_BAR_BOTTOM_CLASS = "pe-dynaform-buttonbar-bottom";
    private static final String FACET_HEADER_CLASS = "pe-dynaform-headerfacet";
    private static final String FACET_FOOTER_CLASS = "pe-dynaform-footerfacet";
    private static final String FACET_STATIC_TOP_CLASS = "pe-dynaform-static-top";
    private static final String FACET_STATIC_BOTTOM_CLASS = "pe-dynaform-static-bottom";
    private static final String EXTENDED_ROW_CLASS = "pe-dynaform-extendedrow";
    private static final String BUTTON_BAR_ROLE = "toolbar";
    private static final String GRID_CELL_ROLE = "gridcell";
    private static final String[] EMPTY_COLUMN_CLASSES = new String[]{"", ""};

    public void encodeEnd(FacesContext fc, UIComponent component) throws IOException {
        DynaForm dynaForm = (DynaForm)component;
        DynaFormModel dynaFormModel = (DynaFormModel)dynaForm.getValue();
        this.encodeMarkup(fc, dynaForm, dynaFormModel, false);
        this.encodeScript(fc, dynaForm, dynaFormModel);
    }

    protected void encodeMarkup(FacesContext fc, DynaForm dynaForm, DynaFormModel dynaFormModel, boolean nestedGrid) throws IOException {
        ResponseWriter writer = fc.getResponseWriter();
        writer.startElement("table", (UIComponent)dynaForm);
        if (!nestedGrid) {
            String clientId = dynaForm.getClientId(fc);
            writer.writeAttribute("id", (Object)clientId, "id");
        }
        String styleClass = nestedGrid ? NESTED_GRID_CLASS : GRID_CLASS;
        styleClass = styleClass + (dynaForm.getStyleClass() == null ? "" : " " + dynaForm.getStyleClass());
        writer.writeAttribute("cellspacing", (Object)"0", "cellspacing");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (dynaForm.getStyle() != null) {
            writer.writeAttribute("style", (Object)dynaForm.getStyle(), "style");
        }
        writer.writeAttribute("role", (Object)"grid", null);
        this.preRenderLabel(fc, dynaForm, dynaFormModel);
        int totalColspan = this.getTotalColspan(dynaFormModel);
        String bbPosition = dynaForm.getButtonBarPosition();
        if (!nestedGrid) {
            if ("top".equals(bbPosition) || "both".equals(bbPosition)) {
                this.encodeFacet(fc, dynaForm, FACET_BUTTON_BAR, totalColspan, FACET_BUTTON_BAR_TOP_CLASS, BUTTON_BAR_ROLE, false, true);
            }
            this.encodeFacet(fc, dynaForm, FACET_HEADER_REGULAR, totalColspan, FACET_HEADER_CLASS, GRID_CELL_ROLE, false, true);
            this.encodeStatic(fc, dynaForm, FACET_STATIC_TOP, totalColspan, FACET_STATIC_TOP_CLASS);
        }
        this.encodeBody(fc, dynaForm, dynaFormModel.getRegularRows(), false, true);
        if (!nestedGrid) {
            this.encodeFacet(fc, dynaForm, FACET_FOOTER_REGULAR, totalColspan, FACET_FOOTER_CLASS, GRID_CELL_ROLE, false, true);
            this.encodeFacet(fc, dynaForm, FACET_HEADER_EXTENDED, totalColspan, FACET_HEADER_CLASS, GRID_CELL_ROLE, true, dynaForm.isOpenExtended());
        }
        this.encodeBody(fc, dynaForm, dynaFormModel.getExtendedRows(), true, dynaForm.isOpenExtended());
        if (!nestedGrid) {
            this.encodeStatic(fc, dynaForm, FACET_STATIC_BOTTOM, totalColspan, FACET_STATIC_BOTTOM_CLASS);
            this.encodeFacet(fc, dynaForm, FACET_FOOTER_EXTENDED, totalColspan, FACET_FOOTER_CLASS, GRID_CELL_ROLE, true, dynaForm.isOpenExtended());
            if ("bottom".equals(bbPosition) || "both".equals(bbPosition)) {
                this.encodeFacet(fc, dynaForm, FACET_BUTTON_BAR, totalColspan, FACET_BUTTON_BAR_BOTTOM_CLASS, BUTTON_BAR_ROLE, false, true);
            }
        }
        writer.endElement("table");
    }

    protected void encodeScript(FacesContext fc, DynaForm dynaForm, DynaFormModel dynaFormModel) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(fc);
        String clientId = dynaForm.getClientId(fc);
        wb.initWithDomReady("ExtDynaForm", dynaForm.resolveWidgetVar(), clientId);
        wb.attr("uuid", dynaFormModel.getUuid());
        wb.attr("autoSubmit", Boolean.valueOf(dynaForm.isAutoSubmit()));
        wb.attr("isPostback", Boolean.valueOf(fc.isPostback()));
        wb.finish();
    }

    protected void encodeFacet(FacesContext fc, DynaForm dynaForm, String name, int totalColspan, String styleClass, String role, boolean extended, boolean visible) throws IOException {
        UIComponent facet = dynaForm.getFacet(name);
        if (facet != null && facet.isRendered()) {
            ResponseWriter writer = fc.getResponseWriter();
            writer.startElement("tr", null);
            if (extended) {
                writer.writeAttribute("class", (Object)EXTENDED_ROW_CLASS, null);
            }
            if (!visible) {
                writer.writeAttribute("style", (Object)"display:none;", null);
            }
            writer.writeAttribute("role", (Object)"row", null);
            writer.startElement("td", null);
            if (totalColspan > 1) {
                writer.writeAttribute("colspan", (Object)totalColspan, null);
            }
            writer.writeAttribute("class", (Object)styleClass, null);
            writer.writeAttribute("role", (Object)role, null);
            facet.encodeAll(fc);
            writer.endElement("td");
            writer.endElement("tr");
        }
    }

    protected void encodeBody(FacesContext fc, DynaForm dynaForm, List<DynaFormRow> dynaFormRows, boolean extended, boolean visible) throws IOException {
        if (dynaFormRows == null || dynaFormRows.isEmpty()) {
            return;
        }
        ResponseWriter writer = fc.getResponseWriter();
        String columnClassesValue = dynaForm.getColumnClasses();
        String[] columnClasses = columnClassesValue == null ? EMPTY_COLUMN_CLASSES : columnClassesValue.split(",");
        String labelCommonClass = columnClasses[0].trim();
        String controlCommonClass = columnClasses.length > 1 ? columnClasses[1].trim() : EMPTY_COLUMN_CLASSES[1];
        for (DynaFormRow dynaFormRow : dynaFormRows) {
            writer.startElement("tr", null);
            if (extended) {
                writer.writeAttribute("class", (Object)EXTENDED_ROW_CLASS, null);
            }
            if (!visible) {
                writer.writeAttribute("style", (Object)"display:none;", null);
            }
            writer.writeAttribute("role", (Object)"row", null);
            List<AbstractDynaFormElement> elements = dynaFormRow.getElements();
            int size = elements.size();
            for (int i = 0; i < size; ++i) {
                AbstractDynaFormElement element = elements.get(i);
                writer.startElement("td", null);
                if (element.getColspan() > 1) {
                    writer.writeAttribute("colspan", (Object)element.getColspan(), null);
                }
                if (element.getRowspan() > 1) {
                    writer.writeAttribute("rowspan", (Object)element.getRowspan(), null);
                }
                String styleClass = CELL_CLASS;
                if (i == 0 && element.getColspan() == 1) {
                    styleClass = styleClass + " " + CELL_FIRST_CLASS;
                }
                if (i == size - 1 && element.getColspan() == 1) {
                    styleClass = styleClass + " " + CELL_LAST_CLASS;
                }
                if (element instanceof DynaFormLabel) {
                    DynaFormLabel label = (DynaFormLabel)element;
                    writer.writeAttribute("class", (Object)(styleClass + " " + LABEL_CLASS + " " + (String)StringUtils.defaultIfBlank((CharSequence)label.getStyleClass(), (CharSequence)"") + " " + labelCommonClass).trim(), null);
                    writer.writeAttribute("role", (Object)GRID_CELL_ROLE, null);
                    writer.startElement("label", null);
                    if (!label.isTargetValid()) {
                        writer.writeAttribute("class", (Object)LABEL_INVALID_CLASS, null);
                    }
                    writer.writeAttribute("for", (Object)label.getTargetClientId(), null);
                    if (label.getValue() != null) {
                        if (label.isEscape()) {
                            writer.writeText((Object)label.getValue(), "value");
                        } else {
                            writer.write(label.getValue());
                        }
                    }
                    if (label.isTargetRequired()) {
                        writer.startElement("span", null);
                        writer.writeAttribute("class", (Object)LABEL_INDICATOR_CLASS, null);
                        writer.write("*");
                        writer.endElement("span");
                    }
                    writer.endElement("label");
                } else if (element instanceof DynaFormControl) {
                    DynaFormControl control = (DynaFormControl)element;
                    dynaForm.setData(control);
                    UIDynaFormControl cell = dynaForm.getControlCell(control.getType());
                    if (cell.getStyle() != null) {
                        writer.writeAttribute("style", (Object)cell.getStyle(), null);
                    }
                    if (cell.getStyleClass() != null) {
                        styleClass = styleClass + " " + cell.getStyleClass();
                    }
                    writer.writeAttribute("class", (Object)(styleClass + " " + controlCommonClass).trim(), null);
                    writer.writeAttribute("role", (Object)GRID_CELL_ROLE, null);
                    cell.encodeAll(fc);
                } else if (element instanceof DynaFormModelElement) {
                    DynaFormModelElement nestedModel = (DynaFormModelElement)element;
                    writer.writeAttribute("class", (Object)styleClass, null);
                    writer.writeAttribute("role", (Object)GRID_CELL_ROLE, null);
                    this.encodeMarkup(fc, dynaForm, nestedModel.getModel(), true);
                }
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
        dynaForm.resetData();
    }

    protected void encodeStatic(FacesContext fc, DynaForm dynaForm, String name, int totalColspan, String styleClass) throws IOException {
        UIComponent facet = dynaForm.getFacet(name);
        if (facet == null || !facet.isRendered()) {
            return;
        }
        List components = facet instanceof Row ? Collections.singletonList(facet) : facet.getChildren();
        ResponseWriter writer = fc.getResponseWriter();
        for (UIComponent child : components) {
            if (!child.isRendered() || !(child instanceof Row)) continue;
            writer.startElement("tr", null);
            if (this.shouldWriteId(child)) {
                writer.writeAttribute("id", (Object)child.getClientId(fc), null);
            }
            writer.writeAttribute("role", (Object)"row", null);
            writer.writeAttribute("class", (Object)styleClass, null);
            int i = 0;
            for (UIComponent column : child.getChildren()) {
                if (!column.isRendered()) continue;
                String columnClass = CELL_CLASS;
                if (i % totalColspan == 0) {
                    columnClass = columnClass + " " + CELL_FIRST_CLASS;
                }
                if ((i + 1) % totalColspan == 0) {
                    columnClass = columnClass + " " + CELL_LAST_CLASS;
                }
                writer.startElement("td", null);
                writer.writeAttribute("role", (Object)GRID_CELL_ROLE, null);
                writer.writeAttribute("class", (Object)columnClass, null);
                column.encodeAll(fc);
                writer.endElement("td");
                ++i;
            }
            writer.endElement("tr");
        }
    }

    protected void preRenderLabel(FacesContext fc, DynaForm dynaForm, DynaFormModel model) {
        for (final DynaFormLabel label : model.getLabels()) {
            UIDynaFormControl cell;
            DynaFormControl control = label.getForControl();
            if (control == null || (cell = dynaForm.getControlCell(control.getType())).getFor() == null) continue;
            dynaForm.setData(control);
            UIComponent target = cell.findComponent(cell.getFor());
            if (target == null) {
                LOGGER.warning("Cannot find component with identifier " + cell.getFor() + " inside UIDynaFormControl");
                continue;
            }
            String targetClientId = target instanceof InputHolder ? ((InputHolder)target).getInputClientId() : target.getClientId(fc);
            label.setTargetClientId(targetClientId);
            ContextCallback callback = new ContextCallback(){

                public void invokeContextCallback(FacesContext context, UIComponent target) {
                    label.setTargetValid(((EditableValueHolder)target).isValid());
                    label.setTargetRequired(((EditableValueHolder)target).isRequired());
                }
            };
            if (CompositeUtils.isComposite((UIComponent)target)) {
                CompositeUtils.invokeOnDeepestEditableValueHolder((FacesContext)fc, (UIComponent)target, (ContextCallback)callback);
            } else {
                callback.invokeContextCallback(fc, target);
            }
            if (label.getValue() != null) {
                target.getAttributes().put("label", label.getValue());
            }
            label.setStyleClass(String.format(LABEL_CONTROL_TYPE_CLASS_FORMAT, control.getType().toLowerCase()));
        }
        dynaForm.resetData();
    }

    protected int getTotalColspan(DynaFormModel dynaFormModel) {
        int totalColspan = -1;
        for (DynaFormRow dynaFormRow : dynaFormModel.getRegularRows()) {
            if (dynaFormRow.getTotalColspan() <= totalColspan) continue;
            totalColspan = dynaFormRow.getTotalColspan();
        }
        if (dynaFormModel.getExtendedRows() != null) {
            for (DynaFormRow dynaFormRow : dynaFormModel.getExtendedRows()) {
                if (dynaFormRow.getTotalColspan() <= totalColspan) continue;
                totalColspan = dynaFormRow.getTotalColspan();
            }
        }
        if (totalColspan < 1) {
            totalColspan = 1;
        }
        return totalColspan;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

