/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.github;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.github.Github;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class GithubRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Github github = (Github)component;
        this.encodeMarkup(context, github);
        this.encodeScript(context, github);
    }

    private void encodeMarkup(FacesContext context, Github github) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = github.getClientId(context);
        String widgetVar = github.resolveWidgetVar();
        writer.startElement("div", (UIComponent)github);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        writer.writeAttribute("data-repo", (Object)github.getRepository(), "data-repo");
        if (github.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)github.getStyleClass(), "styleClass");
        }
        if (github.getStyle() != null) {
            writer.writeAttribute("style", (Object)github.getStyle(), "style");
        }
        writer.endElement("div");
    }

    private void encodeScript(FacesContext context, Github github) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        String clientId = github.getClientId(context);
        wb.init("ExtGitHub", github.resolveWidgetVar(), clientId);
        wb.attr("iconForks", Boolean.valueOf(github.isIconForks()));
        wb.attr("iconIssues", Boolean.valueOf(github.isIconIssues()));
        wb.attr("iconStars", Boolean.valueOf(github.isIconStars()));
        wb.finish();
    }
}

