/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.timepicker;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.extensions.component.timepicker.TimePicker;
import org.primefaces.extensions.util.MessageFactory;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class TimePickerRenderer
extends InputRenderer {
    public void decode(FacesContext fc, UIComponent component) {
        TimePicker timepicker = (TimePicker)component;
        if (!this.shouldDecode((UIInput)timepicker)) {
            return;
        }
        String param = timepicker.getClientId(fc) + "_input";
        String submittedValue = (String)fc.getExternalContext().getRequestParameterMap().get(param);
        if (submittedValue != null) {
            timepicker.setSubmittedValue(submittedValue);
        }
        this.decodeBehaviors(fc, (UIComponent)timepicker);
    }

    public void encodeEnd(FacesContext fc, UIComponent component) throws IOException {
        TimePicker timepicker = (TimePicker)component;
        String value = TimePickerRenderer.getValueAsString(fc, timepicker);
        this.encodeMarkup(fc, timepicker, value);
        this.encodeScript(fc, timepicker, value);
    }

    protected void encodeMarkup(FacesContext fc, TimePicker timepicker, String value) throws IOException {
        ResponseWriter writer = fc.getResponseWriter();
        String clientId = timepicker.getClientId(fc);
        String inputId = clientId + "_input";
        writer.startElement("span", (UIComponent)timepicker);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)"pe-timepicker ui-widget ui-corner-all", null);
        if (timepicker.isInline()) {
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(clientId + "_inline"), null);
            writer.endElement("div");
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)(timepicker.isInline() ? "hidden" : "text"), null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (timepicker.isReadonlyInput()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (!LangUtils.isValueBlank((String)value)) {
            writer.writeAttribute("value", (Object)value, null);
        }
        if (!timepicker.isInline()) {
            String styleClass = timepicker.getStyleClass();
            String string = styleClass = styleClass == null ? "ui-inputfield pe-timepicker-input ui-state-default ui-corner-all" : "ui-inputfield pe-timepicker-input ui-state-default ui-corner-all " + styleClass;
            if (!timepicker.isValid()) {
                styleClass = styleClass + " ui-state-error";
            }
            writer.writeAttribute("class", (Object)styleClass, null);
            if (timepicker.getStyle() != null) {
                writer.writeAttribute("style", (Object)timepicker.getStyle(), null);
            }
        }
        this.renderAccessibilityAttributes(fc, (UIInput)timepicker);
        this.renderPassThruAttributes(fc, (UIComponent)timepicker, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(fc, (UIComponent)timepicker, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(fc, (EditableValueHolder)timepicker);
        writer.endElement("input");
        if (timepicker.isSpinner()) {
            boolean disabled = timepicker.isDisabled() || timepicker.isReadonly();
            this.encodeSpinnerButton(fc, "pe-timepicker-button pe-timepicker-up ui-corner-tr ui-button ui-widget ui-state-default ui-button-text-only", "ui-icon ui-icon-triangle-1-n", disabled);
            this.encodeSpinnerButton(fc, "pe-timepicker-button pe-timepicker-down ui-corner-br ui-button ui-widget ui-state-default ui-button-text-only", "ui-icon ui-icon-triangle-1-s", disabled);
        }
        if (!"focus".equals(timepicker.getShowOn())) {
            writer.startElement("button", null);
            writer.writeAttribute("class", (Object)"pe-timepicker-trigger ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only", null);
            writer.writeAttribute("type", (Object)"button", null);
            writer.writeAttribute("role", (Object)"button", null);
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-button-icon-left ui-icon ui-icon-clock", null);
            writer.endElement("span");
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-button-text", null);
            writer.write("ui-button");
            writer.endElement("span");
            writer.endElement("button");
        }
        writer.endElement("span");
    }

    protected void encodeScript(FacesContext fc, TimePicker timepicker, String value) throws IOException {
        String clientId = timepicker.getClientId(fc);
        WidgetBuilder wb = this.getWidgetBuilder(fc);
        wb.init("ExtTimePicker", timepicker.resolveWidgetVar(), clientId);
        wb.attr("timeSeparator", timepicker.getTimeSeparator());
        wb.attr("myPosition", timepicker.getDialogPosition());
        wb.attr("atPosition", timepicker.getInputPosition());
        wb.attr("showPeriod", Boolean.valueOf(timepicker.isShowPeriod()));
        wb.attr("showPeriodLabels", Boolean.valueOf(timepicker.isShowPeriod()));
        wb.attr("modeInline", Boolean.valueOf(timepicker.isInline()));
        wb.attr("modeSpinner", Boolean.valueOf(timepicker.isSpinner()));
        wb.nativeAttr("hours", "{starts:" + timepicker.getStartHours() + ",ends:" + timepicker.getEndHours() + "}");
        wb.nativeAttr("minutes", "{starts:" + timepicker.getStartMinutes() + ",ends:" + timepicker.getEndMinutes() + ",interval:" + timepicker.getIntervalMinutes() + "}");
        wb.attr("rows", (Number)timepicker.getRows());
        wb.attr("showHours", Boolean.valueOf(timepicker.isShowHours()));
        wb.attr("showMinutes", Boolean.valueOf(timepicker.isShowMinutes()));
        wb.attr("showCloseButton", Boolean.valueOf(timepicker.isShowCloseButton()));
        wb.attr("showNowButton", Boolean.valueOf(timepicker.isShowNowButton()));
        wb.attr("showDeselectButton", Boolean.valueOf(timepicker.isShowDeselectButton()));
        if (timepicker.getOnHourShow() != null) {
            wb.nativeAttr("onHourShow", timepicker.getOnHourShow());
        }
        if (timepicker.getOnMinuteShow() != null) {
            wb.nativeAttr("onMinuteShow", timepicker.getOnMinuteShow());
        }
        if (!"focus".equals(timepicker.getShowOn())) {
            wb.attr("showOn", timepicker.getShowOn());
            wb.selectorAttr("button", "#" + clientId + " .pe-timepicker-trigger");
        }
        wb.attr("locale", timepicker.calculateLocale().toString());
        wb.attr("disabled", Boolean.valueOf(timepicker.isDisabled() || timepicker.isReadonly()));
        if (LangUtils.isValueBlank((String)value)) {
            wb.attr("defaultTime", "");
        } else if (timepicker.isInline()) {
            wb.attr("defaultTime", value);
        }
        if (timepicker.getMinHour() != null || timepicker.getMinMinute() != null) {
            wb.nativeAttr("minTime", "{hour:" + timepicker.getMinHour() + ",minute:" + timepicker.getMinMinute() + "}");
        }
        if (timepicker.getMaxHour() != null || timepicker.getMaxMinute() != null) {
            wb.nativeAttr("maxTime", "{hour:" + timepicker.getMaxHour() + ",minute:" + timepicker.getMaxMinute() + "}");
        }
        this.encodeClientBehaviors(fc, (ClientBehaviorHolder)timepicker);
        wb.finish();
    }

    protected static String getValueAsString(FacesContext fc, TimePicker timepicker) {
        Object submittedValue = timepicker.getSubmittedValue();
        if (submittedValue != null) {
            return submittedValue.toString();
        }
        Object value = timepicker.getValue();
        if (value == null) {
            return null;
        }
        if (timepicker.getConverter() != null) {
            return timepicker.getConverter().getAsString(fc, (UIComponent)timepicker, value);
        }
        SimpleDateFormat timeFormat = timepicker.isShowPeriod() ? new SimpleDateFormat(timepicker.getTimePattern12(), timepicker.calculateLocale()) : new SimpleDateFormat(timepicker.getTimePattern24(), timepicker.calculateLocale());
        return timeFormat.format(value);
    }

    protected void encodeSpinnerButton(FacesContext fc, String styleClass, String iconClass, boolean disabled) throws IOException {
        ResponseWriter writer = fc.getResponseWriter();
        styleClass = disabled ? styleClass + " ui-state-disabled" : styleClass;
        writer.startElement("a", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("span");
        writer.endElement("a");
    }

    public Object getConvertedValue(FacesContext fc, UIComponent component, Object submittedValue) throws ConverterException {
        String value = (String)submittedValue;
        if (LangUtils.isValueBlank((String)value)) {
            return null;
        }
        TimePicker timepicker = (TimePicker)component;
        Converter converter = timepicker.getConverter();
        if (converter != null) {
            return converter.getAsObject(fc, (UIComponent)timepicker, value);
        }
        SimpleDateFormat timeFormat = null;
        try {
            timeFormat = timepicker.isShowPeriod() ? new SimpleDateFormat(timepicker.getTimePattern12(), timepicker.calculateLocale()) : new SimpleDateFormat(timepicker.getTimePattern24(), timepicker.calculateLocale());
            return timeFormat.parse(value);
        }
        catch (ParseException e) {
            throw new ConverterException(MessageFactory.getMessage(timepicker.calculateLocale(), "javax.faces.converter.DateTimeConverter.TIME", value, timeFormat.format(new Date(System.currentTimeMillis())), MessageFactory.getLabel(fc, component)), (Throwable)e);
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
    }
}

