/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.model.fluidgrid;

import java.io.Serializable;
import org.apache.commons.lang3.RandomStringUtils;
import org.primefaces.extensions.model.common.KeyData;

public class FluidGridItem
implements KeyData,
Serializable {
    public static final String DEFAULT_TYPE = "default";
    private static final long serialVersionUID = 1L;
    private String key;
    private Object data;
    private String type;

    public FluidGridItem() {
        this.setKey(this.generateKey());
    }

    public FluidGridItem(Object data) {
        this.data = data;
        this.type = DEFAULT_TYPE;
        this.setKey(this.generateKey());
    }

    public FluidGridItem(Object data, String type) {
        this.data = data;
        this.type = type != null ? type : DEFAULT_TYPE;
        this.setKey(this.generateKey());
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FluidGridItem)) {
            return false;
        }
        FluidGridItem other = (FluidGridItem)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FluidGridItem [key=");
        builder.append(this.key);
        builder.append(", data=");
        builder.append(this.data);
        builder.append(", type=");
        builder.append(this.type);
        builder.append("]");
        return builder.toString();
    }

    public String generateKey() {
        return RandomStringUtils.randomAlphanumeric((int)8);
    }
}

