/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.facade.forked;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.downloadcache.CachedFile;
import org.sonarsource.scanner.downloadcache.DownloadCache;
import org.sonarsource.scanner.downloadcache.Downloader;
import org.sonarsource.scanner.downloadcache.HashMismatchException;
import org.sonarsource.scanner.lib.internal.MessageException;
import org.sonarsource.scanner.lib.internal.facade.forked.JavaRunner;
import org.sonarsource.scanner.lib.internal.facade.forked.JavaRunnerFactory;
import org.sonarsource.scanner.lib.internal.facade.forked.ResourceMetadata;
import org.sonarsource.scanner.lib.internal.facade.forked.ScannerEngineLauncher;
import org.sonarsource.scanner.lib.internal.http.ScannerHttpClient;
import org.sonarsource.scanner.lib.internal.util.Either;
import org.sonarsource.scanner.lib.internal.util.ProcessWrapperFactory;
import org.sonarsource.scanner.lib.internal.util.System2;

public class ScannerEngineLauncherFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ScannerEngineLauncherFactory.class);
    static final String API_PATH_ENGINE = "/analysis/engine";
    private final JavaRunnerFactory javaRunnerFactory;

    public ScannerEngineLauncherFactory(System2 system) {
        this.javaRunnerFactory = new JavaRunnerFactory(system, new ProcessWrapperFactory());
    }

    ScannerEngineLauncherFactory(JavaRunnerFactory javaRunnerFactory) {
        this.javaRunnerFactory = javaRunnerFactory;
    }

    public ScannerEngineLauncher createLauncher(ScannerHttpClient scannerHttpClient, DownloadCache downloadCache, Map<String, String> properties) {
        JavaRunner javaRunner = this.javaRunnerFactory.createRunner(scannerHttpClient, downloadCache, properties);
        ScannerEngineLauncherFactory.jreSanityCheck(javaRunner);
        Either<CachedFile, Path> scannerEngine = ScannerEngineLauncherFactory.getScannerEngine(scannerHttpClient, downloadCache, properties);
        return new ScannerEngineLauncher(javaRunner, scannerEngine);
    }

    private static void jreSanityCheck(JavaRunner javaRunner) {
        javaRunner.execute(Collections.singletonList("--version"), null, arg_0 -> ((Logger)LOG).debug(arg_0));
    }

    private static Either<CachedFile, Path> getScannerEngine(ScannerHttpClient scannerHttpClient, DownloadCache downloadCache, Map<String, String> properties) {
        String scannerEngineJarPathPropValue = properties.get("sonar.scanner.engineJarPath");
        if (scannerEngineJarPathPropValue != null) {
            Path path = Paths.get(scannerEngineJarPathPropValue, new String[0]).toAbsolutePath();
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                throw new MessageException("Scanner Engine jar path '" + scannerEngineJarPathPropValue + "' does not exist. Please check property 'sonar.scanner.engineJarPath'.");
            }
            LOG.info("Using the configured Scanner Engine '{}'", (Object)path);
            return Either.forRight(path);
        }
        return Either.forLeft(ScannerEngineLauncherFactory.provisionScannerEngine(scannerHttpClient, downloadCache, true));
    }

    private static CachedFile provisionScannerEngine(ScannerHttpClient scannerHttpClient, DownloadCache downloadCache, boolean retry) {
        try {
            ScannerEngineMetadata scannerEngineMetadata = ScannerEngineLauncherFactory.getScannerEngineMetadata(scannerHttpClient);
            return downloadCache.getOrDownload(scannerEngineMetadata.getFilename(), scannerEngineMetadata.getSha256(), "SHA-256", (Downloader)new ScannerEngineDownloader(scannerHttpClient, scannerEngineMetadata));
        }
        catch (HashMismatchException e) {
            if (retry) {
                LOG.warn("Failed to get the scanner-engine, retrying...");
                return ScannerEngineLauncherFactory.provisionScannerEngine(scannerHttpClient, downloadCache, false);
            }
            throw new IllegalStateException("Unable to provision the Scanner Engine", e);
        }
    }

    private static ScannerEngineMetadata getScannerEngineMetadata(ScannerHttpClient scannerHttpClient) {
        try {
            String response = scannerHttpClient.callRestApi(API_PATH_ENGINE);
            return (ScannerEngineMetadata)new Gson().fromJson(response, ScannerEngineMetadata.class);
        }
        catch (Exception e) {
            throw new MessageException("Failed to get the scanner-engine metadata: " + e.getMessage(), e);
        }
    }

    static class ScannerEngineMetadata
    extends ResourceMetadata {
        public ScannerEngineMetadata(String filename, String sha256, @Nullable String downloadUrl) {
            super(filename, sha256, downloadUrl);
        }
    }

    static class ScannerEngineDownloader
    implements Downloader {
        private final ScannerHttpClient connection;
        private final ScannerEngineMetadata scannerEngineMetadata;

        ScannerEngineDownloader(ScannerHttpClient connection, ScannerEngineMetadata scannerEngineMetadata) {
            this.connection = connection;
            this.scannerEngineMetadata = scannerEngineMetadata;
        }

        public void download(String filename, Path toFile) throws IOException {
            if (StringUtils.isNotBlank((CharSequence)this.scannerEngineMetadata.getDownloadUrl())) {
                this.connection.downloadFromExternalUrl(this.scannerEngineMetadata.getDownloadUrl(), toFile);
            } else {
                this.connection.downloadFromRestApi(ScannerEngineLauncherFactory.API_PATH_ENGINE, toFile);
            }
        }
    }
}

