/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.types;

import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class RedisClientInfo {
    private final Properties clientProperties;

    public RedisClientInfo(Properties properties) {
        Assert.notNull((Object)properties, (String)"Cannot initialize client information for given 'null' properties");
        this.clientProperties = new Properties();
        this.clientProperties.putAll((Map<?, ?>)properties);
    }

    public String getAddressPort() {
        return this.get(INFO.ADDRESS_PORT);
    }

    public String getFileDescriptor() {
        return this.get(INFO.FILE_DESCRIPTOR);
    }

    public String getName() {
        return this.get(INFO.CONNECTION_NAME);
    }

    public Long getAge() {
        return this.getLongValueOf(INFO.CONNECTION_AGE);
    }

    public Long getIdle() {
        return this.getLongValueOf(INFO.CONNECTION_IDLE);
    }

    public String getFlags() {
        return this.get(INFO.FLAGS);
    }

    public Long getDatabaseId() {
        return this.getLongValueOf(INFO.DATABSE_ID);
    }

    public Long getChannelSubscribtions() {
        return this.getLongValueOf(INFO.CHANNEL_SUBSCRIBTIONS);
    }

    public Long getPatternSubscrbtions() {
        return this.getLongValueOf(INFO.PATTERN_SUBSCRIBTIONS);
    }

    public Long getMultiCommandContext() {
        return this.getLongValueOf(INFO.MULIT_COMMAND_CONTEXT);
    }

    public Long getBufferLength() {
        return this.getLongValueOf(INFO.BUFFER_LENGTH);
    }

    public Long getBufferFreeSpace() {
        return this.getLongValueOf(INFO.BUFFER_FREE_SPACE);
    }

    public Long getOutputBufferLength() {
        return this.getLongValueOf(INFO.OUTPUT_BUFFER_LENGTH);
    }

    public Long getOutputListLength() {
        return this.getLongValueOf(INFO.OUTPUT_LIST_LENGTH);
    }

    public Long getOutputBufferMemoryUsage() {
        return this.getLongValueOf(INFO.OUTPUT_BUFFER_MEMORY_USAGE);
    }

    public String getEvents() {
        return this.get(INFO.EVENTS);
    }

    public String getLastCommand() {
        return this.get(INFO.LAST_COMMAND);
    }

    public String get(INFO info) {
        Assert.notNull((Object)((Object)info), (String)"Cannot retrieve client information for 'null'");
        return this.clientProperties.getProperty(info.key);
    }

    @Nullable
    public String get(String key) {
        Assert.hasText((String)key, (String)"Cannot get client information for 'empty' / 'null' key");
        return this.clientProperties.getProperty(key);
    }

    private Long getLongValueOf(INFO info) {
        String value = this.get(info);
        return value == null ? null : Long.valueOf(value);
    }

    public String toString() {
        return this.clientProperties.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisClientInfo that = (RedisClientInfo)o;
        return ObjectUtils.nullSafeEquals((Object)this.clientProperties, (Object)that.clientProperties);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.clientProperties);
    }

    public static enum INFO {
        ADDRESS_PORT("addr"),
        FILE_DESCRIPTOR("fd"),
        CONNECTION_NAME("name"),
        CONNECTION_AGE("age"),
        CONNECTION_IDLE("idle"),
        FLAGS("flags"),
        DATABSE_ID("db"),
        CHANNEL_SUBSCRIBTIONS("sub"),
        PATTERN_SUBSCRIBTIONS("psub"),
        MULIT_COMMAND_CONTEXT("multi"),
        BUFFER_LENGTH("qbuf"),
        BUFFER_FREE_SPACE("qbuf-free"),
        OUTPUT_BUFFER_LENGTH("obl"),
        OUTPUT_LIST_LENGTH("oll"),
        OUTPUT_BUFFER_MEMORY_USAGE("omem"),
        EVENTS("events"),
        LAST_COMMAND("cmd");

        final String key;

        private INFO(String key) {
            this.key = key;
        }
    }

    public static class RedisClientInfoBuilder {
        public static RedisClientInfo fromString(String source) {
            Assert.notNull((Object)source, (String)"Cannot read client properties form 'null'");
            Properties properties = new Properties();
            try {
                properties.load(new StringReader(source.replace(' ', '\n')));
            }
            catch (IOException ex) {
                String message = String.format("Properties could not be loaded from String '%s'", source);
                throw new IllegalArgumentException(message, ex);
            }
            return new RedisClientInfo(properties);
        }
    }
}

