/*
 * Decompiled with CFR 0.152.
 */
package fr.dutra.tools.maven.deptree.core;

import fr.dutra.tools.maven.deptree.core.AbstractParser;
import fr.dutra.tools.maven.deptree.core.Node;
import fr.dutra.tools.maven.deptree.core.ParseException;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GraphmlParser
extends AbstractParser {
    private static final Pattern ACTIVE_ARTIFACT_PATTERN = Pattern.compile("artifact = (?!active project artifact:)(.+);");

    @Override
    public Node parse(Reader reader) throws ParseException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        try {
            SAXParser saxParser = factory.newSAXParser();
            EventHandler handler = new EventHandler();
            saxParser.parse(new InputSource(reader), (DefaultHandler)handler);
            return handler.getRootNode();
        }
        catch (ParserConfigurationException e) {
            throw new ParseException(e);
        }
        catch (SAXException e) {
            throw new ParseException(e);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    protected String extractActiveProjectArtifact(String content) {
        Matcher matcher = ACTIVE_ARTIFACT_PATTERN.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    protected class EventHandler
    extends DefaultHandler {
        private Map<String, Node> nodes = new HashMap<String, Node>();
        private String currentNodeId;
        private boolean insideNodeLabel;
        private Node root;

        protected EventHandler() {
        }

        public Node getRootNode() {
            return this.root;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("node".equals(localName)) {
                this.currentNodeId = attributes.getValue("", "id");
            }
            if ("edge".equals(localName)) {
                String parentNodeId = attributes.getValue("", "source");
                String childNodeId = attributes.getValue("", "target");
                Node parent = this.nodes.get(parentNodeId);
                Node child = this.nodes.get(childNodeId);
                parent.addChildNode(child);
            }
            this.insideNodeLabel = "NodeLabel".equals(localName);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.insideNodeLabel = false;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.insideNodeLabel) {
                String artifact = String.valueOf(ch, start, length).trim();
                if (artifact.contains("active project artifact")) {
                    artifact = GraphmlParser.this.extractActiveProjectArtifact(artifact);
                }
                Node node = GraphmlParser.this.parseArtifactString(artifact);
                this.nodes.put(this.currentNodeId, node);
                if (this.root == null) {
                    this.root = node;
                }
                this.currentNodeId = null;
            }
        }
    }
}

