/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.pdf.FontDescription;
import org.xhtmlrenderer.pdf.FontFamily;
import org.xhtmlrenderer.pdf.ITextFontResolver;

public class CJKFontResolver
extends ITextFontResolver {
    private static final Logger log = LoggerFactory.getLogger(CJKFontResolver.class);
    private static final String[][] cjkFonts = new String[][]{{"STSong-Light-H", "STSong-Light", "UniGB-UCS2-H"}, {"STSong-Light-V", "STSong-Light", "UniGB-UCS2-V"}, {"STSongStd-Light-H", "STSongStd-Light", "UniGB-UCS2-H"}, {"STSongStd-Light-V", "STSongStd-Light", "UniGB-UCS2-V"}, {"MHei-Medium-H", "MHei-Medium", "UniCNS-UCS2-H"}, {"MHei-Medium-V", "MHei-Medium", "UniCNS-UCS2-V"}, {"MSung-Light-H", "MSung-Light", "UniCNS-UCS2-H"}, {"MSung-Light-V", "MSung-Light", "UniCNS-UCS2-V"}, {"MSungStd-Light-H", "MSungStd-Light", "UniCNS-UCS2-H"}, {"MSungStd-Light-V", "MSungStd-Light", "UniCNS-UCS2-V"}, {"HeiseiMin-W3-H", "HeiseiMin-W3", "UniJIS-UCS2-H"}, {"HeiseiMin-W3-V", "HeiseiMin-W3", "UniJIS-UCS2-V"}, {"HeiseiKakuGo-W5-H", "HeiseiKakuGo-W5", "UniJIS-UCS2-H"}, {"HeiseiKakuGo-W5-V", "HeiseiKakuGo-W5", "UniJIS-UCS2-V"}, {"KozMinPro-Regular-H", "KozMinPro-Regular", "UniJIS-UCS2-HW-H"}, {"KozMinPro-Regular-V", "KozMinPro-Regular", "UniJIS-UCS2-HW-V"}, {"HYGoThic-Medium-H", "HYGoThic-Medium", "UniKS-UCS2-H"}, {"HYGoThic-Medium-V", "HYGoThic-Medium", "UniKS-UCS2-V"}, {"HYSMyeongJo-Medium-H", "HYSMyeongJo-Medium", "UniKS-UCS2-H"}, {"HYSMyeongJo-Medium-V", "HYSMyeongJo-Medium", "UniKS-UCS2-V"}, {"HYSMyeongJoStd-Medium-H", "HYSMyeongJoStd-Medium", "UniKS-UCS2-H"}, {"HYSMyeongJoStd-Medium-V", "HYSMyeongJoStd-Medium", "UniKS-UCS2-V"}};

    @Override
    protected Map<String, FontFamily> loadFonts() {
        Map<String, FontFamily> result = super.loadFonts();
        result.putAll(this.loadCJKFonts());
        return result;
    }

    private Map<String, FontFamily> loadCJKFonts() {
        HashMap<String, FontFamily> fontFamilyMap = new HashMap<String, FontFamily>();
        for (String[] cjkFont : cjkFonts) {
            String fontFamilyName = cjkFont[0];
            String fontName = cjkFont[1];
            String encoding = cjkFont[2];
            try {
                FontFamily fontFamily = this.addCJKFont(fontFamilyName, fontName, encoding);
                fontFamilyMap.put(fontFamilyName, fontFamily);
            }
            catch (DocumentException | IOException e) {
                log.error("Failed to load font {} {} {}: {}", new Object[]{fontFamilyName, fontName, encoding, e.toString()});
            }
        }
        return fontFamilyMap;
    }

    private FontFamily addCJKFont(String fontFamilyName, String fontName, String encoding) throws DocumentException, IOException {
        FontFamily fontFamily = new FontFamily(fontFamilyName);
        fontFamily.addFontDescription(new FontDescription(BaseFont.createFont((String)(fontName + ",BoldItalic"), (String)encoding, (boolean)false), IdentValue.OBLIQUE, 700));
        fontFamily.addFontDescription(new FontDescription(BaseFont.createFont((String)(fontName + ",Italic"), (String)encoding, (boolean)false), IdentValue.OBLIQUE, 400));
        fontFamily.addFontDescription(new FontDescription(BaseFont.createFont((String)(fontName + ",Bold"), (String)encoding, (boolean)false), IdentValue.NORMAL, 700));
        fontFamily.addFontDescription(new FontDescription(BaseFont.createFont((String)fontName, (String)encoding, (boolean)false), IdentValue.NORMAL, 400));
        return fontFamily;
    }
}

