package org.yunchen.gb.plugin.springsecurity.captcha



/**
 * Created by @Author:xiaopeng on 2018/4/21.
 */
import org.springframework.context.ApplicationListener
import org.springframework.security.authentication.event.AuthenticationSuccessEvent
import org.yunchen.gb.core.GbSpringUtils
import org.yunchen.gb.plugin.springsecurity.captcha.event.AppCaptchaSuccessEvent

class AuthenticationSuccessListener implements ApplicationListener<AuthenticationSuccessEvent> {

    LoginAttemptCacheService loginAttemptCacheService

    void onApplicationEvent(AuthenticationSuccessEvent e) {
        GbSpringUtils.publishEvent(new AppCaptchaSuccessEvent(e))
        loginAttemptCacheService.loginSuccess(e.authentication.name)
    }
}
