package org.yunchen.gb.plugin.springsecurity.captcha


import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.ApplicationListener
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent
import org.yunchen.gb.core.GbSpringUtils
import org.yunchen.gb.plugin.springsecurity.captcha.event.AppCaptchaFailureEvent

/**
 * Created by @Author:xiaopeng on 2018/4/21.
 */
class AuthenticationFailureListener implements ApplicationListener<AbstractAuthenticationFailureEvent> {
    @Autowired
    LoginAttemptCacheService loginAttemptCacheService

    void onApplicationEvent(AbstractAuthenticationFailureEvent e) {
        GbSpringUtils.publishEvent(new AppCaptchaFailureEvent(e))
        loginAttemptCacheService.failLogin(e.authentication.name)
    }
}
