package org.yunchen.gb.plugin.springsecurity.captcha


import groovy.util.logging.Slf4j
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler


/**
 * Created by @Author:xiaopeng on 2018/4/21.
 */

import org.springframework.web.context.request.RequestContextHolder
import org.springframework.web.context.request.ServletRequestAttributes
import org.springframework.web.filter.OncePerRequestFilter
import org.yunchen.gb.core.GbSpringUtils
import org.yunchen.gb.plugin.simplecaptcha.SimpleCaptchaService

import javax.servlet.FilterChain
import javax.servlet.ServletException
import javax.servlet.http.HttpServletRequest
import javax.servlet.http.HttpServletResponse
import javax.servlet.http.HttpSession

@Slf4j
public class CaptchaCaptureFilter extends OncePerRequestFilter {
    SpringSecurityCaptchaProperties springSecurityCaptchaProperties
    SimpleCaptchaService simpleCaptchaService
    String failureUrl
    private SimpleUrlAuthenticationFailureHandler failureHandler = new SimpleUrlAuthenticationFailureHandler()

    @Override
    public void doFilterInternal(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpSession session = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes())?.getRequest()?.session;
        try {
            String filterProcessesUrl= GbSpringUtils.getConfiginfo("gb.springsecurity.apf.filterProcessesUrl");
            if(req?.method?.toUpperCase()=='POST' && req?.getRequestURI()?.endsWith(filterProcessesUrl) && session?.getAttribute("captchaForLogin") && isEnabled()) {
                String captchaChallenge = req.getParameter("captchaChallenge")
                boolean verified = simpleCaptchaService.validateCaptcha(req,res,captchaChallenge);
                if(!verified) {
                    // Redirect user to login page
                    failureHandler.setDefaultFailureUrl(failureUrl)
                    failureHandler.onAuthenticationFailure(req, res, new CaptchaVerificationFailedException("Captcha invalid"))
                    return;
                }
            }
        } catch(Exception e){
            log.error(e.getMessage(), e)
        }
        chain.doFilter(req, res)
    }

    boolean isEnabled() {
        return springSecurityCaptchaProperties.enabled
    }

}
