package org.yunchen.gb.plugin.springsecurity.captcha


import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.context.properties.EnableConfigurationProperties
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import org.springframework.core.annotation.Order
import org.springframework.security.config.annotation.web.builders.HttpSecurity
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter
import org.springframework.stereotype.Component
import org.yunchen.gb.plugin.simplecaptcha.SimpleCaptchaService
import org.yunchen.gb.plugin.springsecurity.GbSpringSecurityUtils
import org.yunchen.gb.plugin.springsecurity.config.SpringSecurityConfigurationProperties

/**
 * Created by @Author:xiaopeng on 2018/4/21.
 */
@Order(51)
@Configuration
@Component
@EnableConfigurationProperties([SpringSecurityCaptchaProperties.class, SpringSecurityConfigurationProperties.class])
class SpringSecurityCaptchaConfig extends WebSecurityConfigurerAdapter {
    @Autowired
    SpringSecurityCaptchaProperties springSecurityCaptchaProperties
    @Autowired
    private SpringSecurityConfigurationProperties securityproperties;
    @Autowired
    private LoginAttemptCacheService loginAttemptCacheService
    @Autowired
    SimpleCaptchaService simpleCaptchaService

    @Bean("authenticationFailureListener")
    public AuthenticationFailureListener  getAuthenticationFailureListener(){
        return new AuthenticationFailureListener(loginAttemptCacheService: loginAttemptCacheService);
    }
    @Bean("authenticationSuccessEventListener")
    public AuthenticationSuccessListener  getAuthenticationSuccessListener(){
        return new AuthenticationSuccessListener(loginAttemptCacheService: loginAttemptCacheService);
    }

    //@Bean("captchaCaptureFilter")
    //若设置为bean，则报错Javassist Enhancement failed
    //因为在系统中会自动注册为fileter，匹配为/*
    public CaptchaCaptureFilter  getCaptchaCaptureFilter(){
        return new CaptchaCaptureFilter(springSecurityCaptchaProperties:springSecurityCaptchaProperties,simpleCaptchaService:simpleCaptchaService,failureUrl: securityproperties.failureHandler.defaultFailureUrl);
    }
    @Override
    protected void configure(HttpSecurity http) throws Exception {
        HttpSecurity httpSecurity= GbSpringSecurityUtils.httpSecurity;
        httpSecurity.addFilterBefore(getCaptchaCaptureFilter(),UsernamePasswordAuthenticationFilter.class)
    }
}
