/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.project.MavenProject;

public class GitDirLocator {
    final MavenProject mavenProject;
    final List<MavenProject> reactorProjects;

    public GitDirLocator(MavenProject mavenProject, List<MavenProject> reactorProjects) {
        this.mavenProject = mavenProject;
        this.reactorProjects = reactorProjects;
    }

    @Nullable
    public File lookupGitDirectory(@Nonnull File manuallyConfiguredDir) {
        if (manuallyConfiguredDir.exists()) {
            if (manuallyConfiguredDir.isDirectory()) {
                return manuallyConfiguredDir;
            }
            File gitDirLinkPath = this.processGitDirFile(manuallyConfiguredDir);
            if (GitDirLocator.isExistingDirectory(gitDirLinkPath)) {
                return gitDirLinkPath;
            }
        }
        return this.findProjectGitDirectory();
    }

    @Nullable
    private File findProjectGitDirectory() {
        if (this.mavenProject == null) {
            return null;
        }
        for (File basedir = this.mavenProject.getBasedir(); basedir != null; basedir = basedir.getParentFile()) {
            File gitdir = new File(basedir, ".git");
            if (!gitdir.exists()) continue;
            if (gitdir.isDirectory()) {
                return gitdir;
            }
            if (gitdir.isFile()) {
                return this.processGitDirFile(gitdir);
            }
            return null;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File processGitDirFile(@Nonnull File file) {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = reader.readLine();
            if (line == null) {
                File file2 = null;
                return file2;
            }
            String[] parts = line.split(": ");
            if (parts.length != 2 || !parts[0].equals("gitdir")) {
                File file3 = null;
                return file3;
            }
            File gitDir = new File(parts[1]);
            if (gitDir.isAbsolute()) {
                File file4 = gitDir;
                return file4;
            }
            File file5 = new File(file.getParentFile(), parts[1]);
            return file5;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static boolean isExistingDirectory(@Nullable File fileLocation) {
        return fileLocation != null && fileLocation.exists() && fileLocation.isDirectory();
    }
}

