/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git.build;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import pl.project13.maven.git.build.BuildServerDataProvider;
import pl.project13.maven.git.log.LoggerBridge;

public class BambooBuildServerData
extends BuildServerDataProvider {
    BambooBuildServerData(LoggerBridge log, @Nonnull Map<String, String> env) {
        super(log, env);
    }

    public static boolean isActiveServer(Map<String, String> env) {
        return env.containsKey("bamboo_buildKey") || env.containsKey("bamboo.buildKey") || env.containsKey("BAMBOO_BUILDKEY");
    }

    @Override
    void loadBuildNumber(@Nonnull Properties properties) {
        String buildNumber = Optional.ofNullable(this.env.get("bamboo.buildNumber")).orElseGet(() -> (String)this.env.get("BAMBOO_BUILDNUMBER"));
        this.put(properties, "build.number", buildNumber == null ? "" : buildNumber);
    }

    @Override
    public String getBuildBranch() {
        String environmentBasedKey = null;
        String environmentBasedBranch = null;
        for (String envKey : Arrays.asList("bamboo.planRepository.branchName", "bamboo.planRepository.<position>.branchName", "BAMBOO_PLANREPOSITORY_BRANCH")) {
            environmentBasedBranch = (String)this.env.get(envKey);
            if (environmentBasedBranch == null) continue;
            environmentBasedKey = envKey;
            break;
        }
        this.log.info("Using environment variable based branch name. {} = {}", (Object)environmentBasedKey, (Object)environmentBasedBranch);
        return environmentBasedBranch;
    }
}

