/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.graph;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.kth.depclean.core.analysis.graph.DependencyGraph;
import se.kth.depclean.core.model.Dependency;

public class MavenDependencyGraph
implements DependencyGraph {
    private static final Logger log = LoggerFactory.getLogger(MavenDependencyGraph.class);
    private final Set<Dependency> allDependencies;
    private final MavenProject project;
    private final DependencyNode rootNode;
    private final Set<Dependency> directDependencies;
    private final Set<Dependency> inheritedDependencies;
    private final Set<Dependency> transitiveDependencies;
    private final Multimap<Dependency, Dependency> dependenciesPerDependency = ArrayListMultimap.create();

    public MavenDependencyGraph(MavenProject project, Model model, DependencyNode rootNode) {
        this.project = project;
        this.rootNode = rootNode;
        this.allDependencies = (Set)project.getArtifacts().stream().map(this::toDepCleanDependency).collect(ImmutableSet.toImmutableSet());
        this.directDependencies = (Set)model.getDependencies().stream().map(this::toDepCleanDependency).collect(ImmutableSet.toImmutableSet());
        this.inheritedDependencies = this.inheritedDependencies(project.getDependencyArtifacts());
        this.transitiveDependencies = this.transitiveDependencies(this.allDependencies);
        this.buildDependencyDependencies(rootNode);
        if (log.isDebugEnabled()) {
            this.allDependencies.forEach(dep -> {
                log.debug("Found dependency {}", dep);
                if (this.dependenciesPerDependency.get(dep) != null) {
                    this.dependenciesPerDependency.get(dep).forEach(transDep -> log.debug("# {}", transDep));
                }
            });
        }
    }

    public Dependency projectCoordinates() {
        log.info("project's jar {}", (Object)(this.project.getBuild().getDirectory() + "/" + this.project.getBuild().getFinalName()));
        return new Dependency(this.rootNode.getArtifact().getGroupId(), this.rootNode.getArtifact().getArtifactId(), this.rootNode.getArtifact().getVersion(), new File(this.project.getBuild().getDirectory() + "/" + this.project.getBuild().getFinalName() + ".jar"));
    }

    public Set<Dependency> allDependencies() {
        return this.allDependencies;
    }

    public Set<Dependency> getDependenciesForParent(Dependency parent) {
        return ImmutableSet.copyOf((Collection)this.dependenciesPerDependency.get((Object)parent));
    }

    public Set<Dependency> directDependencies() {
        return this.directDependencies;
    }

    public Set<Dependency> inheritedDependencies() {
        return this.inheritedDependencies;
    }

    @NotNull
    private Set<Dependency> inheritedDependencies(Set<Artifact> dependencyArtifacts) {
        Set visibleDependencies = dependencyArtifacts.stream().map(this::toDepCleanDependency).collect(Collectors.toSet());
        visibleDependencies.removeAll(this.directDependencies);
        return ImmutableSet.copyOf(visibleDependencies);
    }

    public Set<Dependency> transitiveDependencies() {
        return this.transitiveDependencies;
    }

    @NotNull
    private Set<Dependency> transitiveDependencies(Set<Dependency> allArtifactsFound) {
        HashSet transitiveDependencies = Sets.newHashSet(allArtifactsFound);
        transitiveDependencies.removeAll(this.directDependencies);
        transitiveDependencies.removeAll(this.inheritedDependencies);
        return ImmutableSet.copyOf((Collection)transitiveDependencies);
    }

    private void buildDependencyDependencies(DependencyNode parentNode) {
        for (DependencyNode child : parentNode.getChildren()) {
            if (child.getChildren().isEmpty()) continue;
            child.getChildren().forEach(c -> {
                this.dependenciesPerDependency.put((Object)this.toDepCleanDependency(child), (Object)this.toDepCleanDependency((DependencyNode)c));
                this.buildDependencyDependencies((DependencyNode)c);
            });
        }
    }

    private Dependency toDepCleanDependency(Artifact artifact) {
        return new Dependency(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope(), artifact.getFile());
    }

    private Dependency toDepCleanDependency(DependencyNode node) {
        return this.toDepCleanDependency(node.getArtifact());
    }

    private Dependency toDepCleanDependency(org.apache.maven.model.Dependency dependency) {
        return this.allDependencies.stream().filter(artifact -> this.matches((Dependency)artifact, dependency)).findFirst().get();
    }

    private boolean matches(Dependency dependencyCoordinate, org.apache.maven.model.Dependency dependency) {
        return dependencyCoordinate.getGroupId().equalsIgnoreCase(dependency.getGroupId()) && dependencyCoordinate.getDependencyId().equalsIgnoreCase(dependency.getArtifactId());
    }
}

