/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.wrapper;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import se.kth.depclean.core.AbstractDebloater;
import se.kth.depclean.core.analysis.graph.DependencyGraph;
import se.kth.depclean.core.analysis.model.ProjectDependencyAnalysis;
import se.kth.depclean.core.analysis.src.ImportsAnalyzer;
import se.kth.depclean.core.wrapper.DependencyManagerWrapper;
import se.kth.depclean.graph.MavenDependencyGraph;
import se.kth.depclean.util.JarUtils;
import se.kth.depclean.util.MavenDebloater;
import se.kth.depclean.util.MavenInvoker;
import se.kth.depclean.util.json.ParsedDependencies;

public class MavenDependencyManager
implements DependencyManagerWrapper {
    private static final String DIRECTORY_TO_COPY_DEPENDENCIES = "dependency";
    private final Log logger;
    private final MavenProject project;
    private final MavenSession session;
    private final DependencyGraphBuilder dependencyGraphBuilder;
    private final Model model;

    public MavenDependencyManager(Log logger, MavenProject project, MavenSession session, DependencyGraphBuilder dependencyGraphBuilder) {
        this.logger = logger;
        this.project = project;
        this.session = session;
        this.dependencyGraphBuilder = dependencyGraphBuilder;
        this.model = this.buildModel(project);
    }

    public Log getLog() {
        return this.logger;
    }

    public boolean isMaven() {
        return true;
    }

    public boolean isPackagingPom() {
        return this.project.getPackaging().equals("pom");
    }

    public void copyAndExtractDependencies() {
        String dependencyDirectoryName;
        File dependencyDirectory;
        try {
            MavenInvoker.runCommand("mvn dependency:copy-dependencies -DoutputDirectory=" + this.project.getBuild().getDirectory() + File.separator + DIRECTORY_TO_COPY_DEPENDENCIES, null);
        }
        catch (IOException | InterruptedException e) {
            this.getLog().error((CharSequence)"Unable to resolve all the dependencies.");
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        if (new File(this.project.getBuild().getDirectory() + File.separator + "libs").exists()) {
            try {
                FileUtils.copyDirectory((File)new File(this.project.getBuild().getDirectory() + File.separator + "libs"), (File)new File(this.project.getBuild().getDirectory() + File.separator + DIRECTORY_TO_COPY_DEPENDENCIES));
            }
            catch (IOException | NullPointerException e) {
                this.getLog().error((CharSequence)"Error copying directory libs to dependency");
                throw new RuntimeException(e);
            }
        }
        if ((dependencyDirectory = new File(dependencyDirectoryName = this.project.getBuild().getDirectory() + "/" + DIRECTORY_TO_COPY_DEPENDENCIES)).exists()) {
            JarUtils.decompress(dependencyDirectoryName);
        }
    }

    public DependencyGraph dependencyGraph() {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setProject(this.project);
        DependencyNode rootNode = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, null);
        return new MavenDependencyGraph(this.project, this.model, rootNode);
    }

    public Path getOutputDirectory() {
        return Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]);
    }

    public Path getTestOutputDirectory() {
        return Paths.get(this.project.getBuild().getTestOutputDirectory(), new String[0]);
    }

    private Model buildModel(MavenProject project) {
        Model model;
        File pomFile = new File(project.getBasedir().getAbsolutePath() + File.separator + "pom.xml");
        MavenXpp3Reader mavenReader = new MavenXpp3Reader();
        try {
            FileReader reader = new FileReader(pomFile);
            model = mavenReader.read((Reader)reader);
            model.setPomFile(pomFile);
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"Unable to build the maven project.");
            throw new RuntimeException(ex);
        }
        return model;
    }

    public Set<String> collectUsedClassesFromProcessors() {
        this.getLog().debug((CharSequence)"# collectUsedClassesFromProcessors()");
        return Optional.ofNullable(this.project.getPlugin("org.bsc.maven:maven-processor-plugin")).map(plugin -> (PluginExecution)plugin.getExecutionsAsMap().get("process")).map(exec -> (Xpp3Dom)exec.getConfiguration()).map(config -> config.getChild("processors")).map(Xpp3Dom::getChildren).map(arr -> Arrays.stream(arr).map(Xpp3Dom::getValue).collect(Collectors.toSet())).orElse((Set)ImmutableSet.of());
    }

    public Path getDependenciesDirectory() {
        String dependencyDirectoryName = this.project.getBuild().getDirectory() + "/" + DIRECTORY_TO_COPY_DEPENDENCIES;
        return new File(dependencyDirectoryName).toPath();
    }

    public Set<String> collectUsedClassesFromSource(Path sourceDirectory, Path testSourceDirectory) {
        HashSet<String> allImports = new HashSet<String>();
        ImportsAnalyzer importsInSourceFolder = new ImportsAnalyzer(sourceDirectory);
        ImportsAnalyzer importsInTestsFolder = new ImportsAnalyzer(testSourceDirectory);
        Set importsInSourceFolderSet = importsInSourceFolder.collectImportedClassesFromSource();
        Set importsInTestsFolderSet = importsInTestsFolder.collectImportedClassesFromSource();
        allImports.addAll(importsInSourceFolderSet);
        allImports.addAll(importsInTestsFolderSet);
        return allImports;
    }

    public AbstractDebloater<? extends Serializable> getDebloater(ProjectDependencyAnalysis analysis) {
        return new MavenDebloater(analysis, this.project, this.model);
    }

    public String getBuildDirectory() {
        return this.project.getBuild().getDirectory();
    }

    public Path getSourceDirectory() {
        return new File(this.project.getBuild().getSourceDirectory()).toPath();
    }

    public Path getTestDirectory() {
        return new File(this.project.getBuild().getTestSourceDirectory()).toPath();
    }

    public void generateDependencyTree(File treeFile) throws IOException, InterruptedException {
        MavenInvoker.runCommand("mvn dependency:tree -DoutputFile=" + treeFile + " -Dverbose=true", null);
    }

    public String getTreeAsJson(File treeFile, ProjectDependencyAnalysis analysis, File classUsageFile, boolean createCallGraphCsv) {
        return new ParsedDependencies(treeFile, analysis, classUsageFile, createCallGraphCsv).parseTreeToJson();
    }

    public MavenDependencyManager(Log logger, MavenProject project, MavenSession session, DependencyGraphBuilder dependencyGraphBuilder, Model model) {
        this.logger = logger;
        this.project = project;
        this.session = session;
        this.dependencyGraphBuilder = dependencyGraphBuilder;
        this.model = model;
    }
}

