/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean;

import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.kth.depclean.core.DepCleanManager;
import se.kth.depclean.core.analysis.AnalysisFailureException;
import se.kth.depclean.core.wrapper.DependencyManagerWrapper;
import se.kth.depclean.wrapper.MavenDependencyManager;

@Mojo(name="depclean", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class DepCleanMojo
extends AbstractMojo {
    private static final Logger log = LoggerFactory.getLogger(DepCleanMojo.class);
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="createPomDebloated", defaultValue="false")
    private boolean createPomDebloated;
    @Parameter(property="createResultJson", defaultValue="false")
    private boolean createResultJson;
    @Parameter(property="createCallGraphCsv", defaultValue="false")
    private boolean createCallGraphCsv;
    @Parameter(property="ignoreDependencies")
    private Set<String> ignoreDependencies;
    @Parameter(property="ignoreScopes")
    private Set<String> ignoreScopes;
    @Parameter(property="ignoreTests", defaultValue="false")
    private boolean ignoreTests;
    @Parameter(property="failIfUnusedDirect", defaultValue="false")
    private boolean failIfUnusedDirect;
    @Parameter(property="failIfUnusedTransitive", defaultValue="false")
    private boolean failIfUnusedTransitive;
    @Parameter(property="failIfUnusedInheritedDirect", defaultValue="false")
    private boolean failIfUnusedInheritedDirect;
    @Parameter(property="failIfUnusedInheritedTransitive", defaultValue="false")
    private boolean failIfUnusedInheritedTransitive;
    @Parameter(property="skipDepClean", defaultValue="false")
    private boolean skipDepClean;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;

    public final void execute() {
        try {
            new DepCleanManager((DependencyManagerWrapper)new MavenDependencyManager(this.getLog(), this.project, this.session, this.dependencyGraphBuilder), this.skipDepClean, this.ignoreTests, this.ignoreScopes, this.ignoreDependencies, this.failIfUnusedDirect, this.failIfUnusedTransitive, this.failIfUnusedInheritedDirect, this.failIfUnusedInheritedTransitive, this.createPomDebloated, this.createResultJson, this.createCallGraphCsv).execute();
        }
        catch (AnalysisFailureException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

