/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.graph;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.kth.depclean.core.analysis.graph.DependencyGraph;
import se.kth.depclean.core.model.Dependency;

public class MavenDependencyGraph
implements DependencyGraph {
    private static final Logger log = LoggerFactory.getLogger(MavenDependencyGraph.class);
    private final Set<Dependency> allDependencies;
    private final MavenProject project;
    private final DependencyNode rootNode;
    private final Set<Dependency> directDependencies;
    private final Set<Dependency> transitiveDependencies;
    private final Set<Dependency> inheritedDirectDependencies;
    private final Set<Dependency> inheritedTransitiveDependencies;
    private final Multimap<Dependency, Dependency> dependenciesPerDependency = ArrayListMultimap.create();

    public MavenDependencyGraph(MavenProject project, Model model, DependencyNode rootNode) {
        this.project = project;
        this.rootNode = rootNode;
        this.buildDependencyDependencies(rootNode);
        this.allDependencies = this.getAllDependencies(project);
        this.directDependencies = this.getDirectDependencies(model);
        this.inheritedDirectDependencies = this.inheritedDirectDependencies(project.getDependencyArtifacts());
        this.inheritedTransitiveDependencies = this.inheritedTransitiveDependencies(this.inheritedDirectDependencies, new HashSet<Dependency>());
        this.transitiveDependencies = this.transitiveDependencies(this.allDependencies);
        log.debug("Direct dependencies" + this.directDependencies);
        log.debug("Inherited direct dependencies" + this.inheritedDirectDependencies);
        log.debug("Inherited transitive dependencies" + this.inheritedTransitiveDependencies);
        log.debug("Transitive dependencies" + this.transitiveDependencies);
        if (log.isDebugEnabled()) {
            this.allDependencies.forEach(dep -> {
                log.debug("Found dependency {}", dep);
                if (this.dependenciesPerDependency.get(dep) != null) {
                    this.dependenciesPerDependency.get(dep).forEach(transDep -> log.debug("# {}", transDep));
                }
            });
        }
    }

    public Dependency projectCoordinates() {
        File projectJarFile = new File(this.project.getBuild().getDirectory() + File.separator + this.project.getBuild().getFinalName() + ".jar").exists() ? new File(this.project.getBuild().getDirectory() + File.separator + this.project.getBuild().getFinalName() + ".jar") : null;
        return new Dependency(this.rootNode.getArtifact().getGroupId(), this.rootNode.getArtifact().getArtifactId(), this.rootNode.getArtifact().getVersion(), projectJarFile);
    }

    public Set<Dependency> directDependencies() {
        return this.directDependencies;
    }

    public Set<Dependency> transitiveDependencies() {
        return this.transitiveDependencies;
    }

    @NotNull
    private Set<Dependency> transitiveDependencies(Set<Dependency> allDependencies) {
        HashSet allTransitiveDependencies = Sets.newHashSet(allDependencies);
        allTransitiveDependencies.removeAll(this.directDependencies);
        allTransitiveDependencies.removeAll(this.inheritedDirectDependencies);
        allTransitiveDependencies.removeAll(this.inheritedTransitiveDependencies);
        return ImmutableSet.copyOf((Collection)allTransitiveDependencies);
    }

    public Set<Dependency> inheritedDirectDependencies() {
        return this.inheritedDirectDependencies;
    }

    @NotNull
    private Set<Dependency> inheritedDirectDependencies(Set<Artifact> dependencyArtifacts) {
        Set visibleDependencies = dependencyArtifacts.stream().map(this::toDepCleanDependency).collect(Collectors.toSet());
        visibleDependencies.removeAll(this.directDependencies);
        return ImmutableSet.copyOf(visibleDependencies);
    }

    public Set<Dependency> inheritedTransitiveDependencies() {
        return this.inheritedTransitiveDependencies;
    }

    @NotNull
    private Set<Dependency> inheritedTransitiveDependencies(Set<Dependency> inheritedDirectDependencies, Set<Dependency> inheritedTransitiveDependencies) {
        if (!inheritedDirectDependencies.isEmpty()) {
            for (Dependency inheritedDirectDependency : inheritedDirectDependencies) {
                HashSet<Dependency> c = new HashSet<Dependency>(this.dependenciesPerDependency.get((Object)inheritedDirectDependency));
                for (Dependency d : c) {
                    this.project.getArtifacts().stream().filter(artifact -> artifact.getGroupId().equals(d.getGroupId()) && artifact.getArtifactId().equals(d.getDependencyId())).findFirst().ifPresent(artifact -> {
                        if (artifact.getVersion().equals(d.getVersion())) {
                            inheritedTransitiveDependencies.add(this.toDepCleanDependency((Artifact)artifact));
                        }
                    });
                }
                this.inheritedTransitiveDependencies(c, inheritedTransitiveDependencies);
            }
        }
        return ImmutableSet.copyOf(inheritedTransitiveDependencies);
    }

    public Set<Dependency> getDependenciesForParent(Dependency parent) {
        return ImmutableSet.copyOf((Collection)this.dependenciesPerDependency.get((Object)parent));
    }

    public Set<Dependency> allDependencies() {
        return this.allDependencies;
    }

    private void buildDependencyDependencies(DependencyNode parentNode) {
        parentNode.getChildren().forEach(childNode -> {
            this.dependenciesPerDependency.put((Object)this.toDepCleanDependency(parentNode.getArtifact()), (Object)this.toDepCleanDependency(childNode.getArtifact()));
            this.buildDependencyDependencies((DependencyNode)childNode);
        });
    }

    private Dependency toDepCleanDependency(Artifact artifact) {
        return new Dependency(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope(), artifact.getFile());
    }

    private Dependency toDepCleanDependency(DependencyNode node) {
        return this.toDepCleanDependency(node.getArtifact());
    }

    private Dependency toDepCleanDependency(org.apache.maven.model.Dependency dependency) {
        for (Dependency artifact : this.allDependencies) {
            if (!this.matches(artifact, dependency)) continue;
            return Optional.of(artifact).get();
        }
        return null;
    }

    private boolean matches(Dependency dependencyCoordinate, org.apache.maven.model.Dependency dependency) {
        return dependencyCoordinate.getGroupId().equalsIgnoreCase(dependency.getGroupId()) && dependencyCoordinate.getDependencyId().equalsIgnoreCase(dependency.getArtifactId());
    }

    private ImmutableSet<Dependency> getAllDependencies(MavenProject project) {
        return (ImmutableSet)project.getArtifacts().stream().map(this::toDepCleanDependency).collect(ImmutableSet.toImmutableSet());
    }

    private ImmutableSet<Dependency> getDirectDependencies(Model model) {
        return (ImmutableSet)model.getDependencies().stream().map(this::toDepCleanDependency).collect(ImmutableSet.toImmutableSet());
    }
}

