/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.lowlevel.dsp;

import org.tritonus.lowlevel.dsp.Complex;
import org.tritonus.lowlevel.dsp.HammingWindow;
import org.tritonus.lowlevel.dsp.RectangularWindow;
import org.tritonus.lowlevel.dsp.Util;
import org.tritonus.lowlevel.dsp.Window;

public class FilterDesign {
    public static final int WINDOW_UNKNOWN = -1;
    public static final int WINDOW_RECTANGULAR = 0;
    public static final int WINDOW_HAMMING = 1;
    private static final Window[] WINDOWS = new Window[]{new RectangularWindow(), new HammingWindow()};
    private static final boolean DEBUG = false;

    public static double[] designFrequencySampling(double[] adFrequencyResponse) {
        double dPhase;
        int k;
        int nHalfLength = adFrequencyResponse.length;
        int nFullLength = nHalfLength * 2;
        Complex[] aFrequencyResponse = new Complex[nFullLength];
        double dScaleFactor = (double)(nFullLength - 1) / (double)nFullLength;
        for (k = 0; k < nHalfLength; ++k) {
            dPhase = -Math.PI * (double)k * dScaleFactor;
        }
        for (k = nHalfLength; k < nFullLength; ++k) {
            dPhase = Math.PI - Math.PI * (double)k * dScaleFactor;
        }
        Complex[] aComplexCoefficients = Util.IDFT(aFrequencyResponse);
        double[] aRealCoefficients = new double[nFullLength];
        for (int i = 0; i < nFullLength; ++i) {
            aRealCoefficients[i] = aComplexCoefficients[i].real();
        }
        return aRealCoefficients;
    }

    public static double[] designRectangularLowPass(int nOrder, double dCornerOmega) {
        double[] adH = new double[nOrder];
        int nMiddle = nOrder / 2;
        for (int n = 0; n < nOrder; ++n) {
            adH[n] = Math.sin(dCornerOmega * (double)(n - nMiddle)) / (Math.PI * (double)(n - nMiddle));
        }
        return adH;
    }

    public static double[] designRectangularHighPass(int nOrder, double dCornerOmega) {
        double[] adH = new double[nOrder];
        int nMiddle = nOrder / 2;
        for (int n = 0; n < nOrder; ++n) {
            adH[n] = 1.0 - Math.sin(dCornerOmega * (double)(n - nMiddle)) / (Math.PI * (double)(n - nMiddle));
        }
        return adH;
    }

    public static double[] designRectangularBandPass(int nOrder, double dCornerOmega1, double dCornerOmega2) {
        double[] adH = new double[nOrder];
        int nMiddle = nOrder / 2;
        for (int n = 0; n < nOrder; ++n) {
            adH[n] = (Math.sin(dCornerOmega2 * (double)(n - nMiddle)) - Math.sin(dCornerOmega1 * (double)(n - nMiddle))) / (Math.PI * (double)(n - nMiddle));
        }
        return adH;
    }

    public static double[] designRectangularBandStop(int nOrder, double dCornerOmega1, double dCornerOmega2) {
        double[] adH = new double[nOrder];
        int nMiddle = nOrder / 2;
        for (int n = 0; n < nOrder; ++n) {
            adH[n] = 1.0 - (Math.sin(dCornerOmega2 * (double)(n - nMiddle)) - Math.sin(dCornerOmega1 * (double)(n - nMiddle))) / (Math.PI * (double)(n - nMiddle));
        }
        return adH;
    }

    public static double[] designWindowLowPass(int nOrder, double dCornerOmega, int nWindow) {
        Window window = WINDOWS[nWindow];
        return FilterDesign.designWindowLowPass(nOrder, dCornerOmega, window);
    }

    public static double[] designWindowHighPass(int nOrder, double dCornerOmega, int nWindow) {
        Window window = WINDOWS[nWindow];
        return FilterDesign.designWindowHighPass(nOrder, dCornerOmega, window);
    }

    public static double[] designWindowBandPass(int nOrder, double dCornerOmega1, double dCornerOmega2, int nWindow) {
        Window window = WINDOWS[nWindow];
        return FilterDesign.designWindowBandPass(nOrder, dCornerOmega1, dCornerOmega2, window);
    }

    public static double[] designWindowBandStop(int nOrder, double dCornerOmega1, double dCornerOmega2, int nWindow) {
        Window window = WINDOWS[nWindow];
        return FilterDesign.designWindowBandStop(nOrder, dCornerOmega1, dCornerOmega2, window);
    }

    public static double[] designWindowLowPass(int nOrder, double dCornerOmega, Window window) {
        double[] adRectangular = FilterDesign.designRectangularLowPass(nOrder, dCornerOmega);
        double[] adWindow = window.getWindow(nOrder);
        double[] adH = Util.multiply(adRectangular, adWindow);
        return adH;
    }

    public static double[] designWindowHighPass(int nOrder, double dCornerOmega, Window window) {
        double[] adRectangular = FilterDesign.designRectangularHighPass(nOrder, dCornerOmega);
        double[] adWindow = window.getWindow(nOrder);
        double[] adH = Util.multiply(adRectangular, adWindow);
        return adH;
    }

    public static double[] designWindowBandPass(int nOrder, double dCornerOmega1, double dCornerOmega2, Window window) {
        double[] adRectangular = FilterDesign.designRectangularBandPass(nOrder, dCornerOmega1, dCornerOmega2);
        double[] adWindow = window.getWindow(nOrder);
        double[] adH = Util.multiply(adRectangular, adWindow);
        return adH;
    }

    public static double[] designWindowBandStop(int nOrder, double dCornerOmega1, double dCornerOmega2, Window window) {
        double[] adRectangular = FilterDesign.designRectangularBandStop(nOrder, dCornerOmega1, dCornerOmega2);
        double[] adWindow = window.getWindow(nOrder);
        double[] adH = Util.multiply(adRectangular, adWindow);
        return adH;
    }
}

