// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Operation detail for a document in a batch analysis.
 */
@Immutable
public final class AnalyzeBatchResultDetails implements JsonSerializable<AnalyzeBatchResultDetails> {

    /*
     * Analyze status. succeeded, failed, or skipped
     */
    @Generated
    private final DocumentIntelligenceOperationStatus status;

    /*
     * URL of the source document.
     */
    @Generated
    private final String sourceUrl;

    /*
     * URL of the analyze result JSON.
     */
    @Generated
    private String resultUrl;

    /*
     * Encountered error.
     */
    @Generated
    private DocumentIntelligenceError error;

    /**
     * Creates an instance of AnalyzeBatchResultDetails class.
     *
     * @param status the status value to set.
     * @param sourceUrl the sourceUrl value to set.
     */
    @Generated
    private AnalyzeBatchResultDetails(DocumentIntelligenceOperationStatus status, String sourceUrl) {
        this.status = status;
        this.sourceUrl = sourceUrl;
    }

    /**
     * Get the status property: Analyze status. succeeded, failed, or skipped.
     *
     * @return the status value.
     */
    @Generated
    public DocumentIntelligenceOperationStatus getStatus() {
        return this.status;
    }

    /**
     * Get the sourceUrl property: URL of the source document.
     *
     * @return the sourceUrl value.
     */
    @Generated
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    /**
     * Get the resultUrl property: URL of the analyze result JSON.
     *
     * @return the resultUrl value.
     */
    @Generated
    public String getResultUrl() {
        return this.resultUrl;
    }

    /**
     * Get the error property: Encountered error.
     *
     * @return the error value.
     */
    @Generated
    public DocumentIntelligenceError getError() {
        return this.error;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("sourceUrl", this.sourceUrl);
        jsonWriter.writeStringField("resultUrl", this.resultUrl);
        jsonWriter.writeJsonField("error", this.error);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AnalyzeBatchResultDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AnalyzeBatchResultDetails if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AnalyzeBatchResultDetails.
     */
    @Generated
    public static AnalyzeBatchResultDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DocumentIntelligenceOperationStatus status = null;
            String sourceUrl = null;
            String resultUrl = null;
            DocumentIntelligenceError error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    status = DocumentIntelligenceOperationStatus.fromString(reader.getString());
                } else if ("sourceUrl".equals(fieldName)) {
                    sourceUrl = reader.getString();
                } else if ("resultUrl".equals(fieldName)) {
                    resultUrl = reader.getString();
                } else if ("error".equals(fieldName)) {
                    error = DocumentIntelligenceError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            AnalyzeBatchResultDetails deserializedAnalyzeBatchResultDetails
                = new AnalyzeBatchResultDetails(status, sourceUrl);
            deserializedAnalyzeBatchResultDetails.resultUrl = resultUrl;
            deserializedAnalyzeBatchResultDetails.error = error;
            return deserializedAnalyzeBatchResultDetails;
        });
    }
}
