// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * An object describing the location and semantic content of a document.
 */
@Immutable
public final class AnalyzedDocument implements JsonSerializable<AnalyzedDocument> {

    /*
     * Document type.
     */
    @Generated
    private final String documentType;

    /*
     * Bounding regions covering the document.
     */
    @Generated
    private List<BoundingRegion> boundingRegions;

    /*
     * Location of the document in the reading order concatenated content.
     */
    @Generated
    private final List<DocumentSpan> spans;

    /*
     * Dictionary of named field values.
     */
    @Generated
    private Map<String, DocumentField> fields;

    /*
     * Confidence of correctly extracting the document.
     */
    @Generated
    private final double confidence;

    /**
     * Creates an instance of AnalyzedDocument class.
     *
     * @param documentType the documentType value to set.
     * @param spans the spans value to set.
     * @param confidence the confidence value to set.
     */
    @Generated
    private AnalyzedDocument(String documentType, List<DocumentSpan> spans, double confidence) {
        this.documentType = documentType;
        this.spans = spans;
        this.confidence = confidence;
    }

    /**
     * Get the documentType property: Document type.
     *
     * @return the documentType value.
     */
    @Generated
    public String getDocumentType() {
        return this.documentType;
    }

    /**
     * Get the boundingRegions property: Bounding regions covering the document.
     *
     * @return the boundingRegions value.
     */
    @Generated
    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    /**
     * Get the spans property: Location of the document in the reading order concatenated content.
     *
     * @return the spans value.
     */
    @Generated
    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    /**
     * Get the fields property: Dictionary of named field values.
     *
     * @return the fields value.
     */
    @Generated
    public Map<String, DocumentField> getFields() {
        return this.fields;
    }

    /**
     * Get the confidence property: Confidence of correctly extracting the document.
     *
     * @return the confidence value.
     */
    @Generated
    public double getConfidence() {
        return this.confidence;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("docType", this.documentType);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeDoubleField("confidence", this.confidence);
        jsonWriter.writeArrayField("boundingRegions", this.boundingRegions,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeMapField("fields", this.fields, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AnalyzedDocument from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AnalyzedDocument if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AnalyzedDocument.
     */
    @Generated
    public static AnalyzedDocument fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String documentType = null;
            List<DocumentSpan> spans = null;
            double confidence = 0.0;
            List<BoundingRegion> boundingRegions = null;
            Map<String, DocumentField> fields = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("docType".equals(fieldName)) {
                    documentType = reader.getString();
                } else if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                } else if ("confidence".equals(fieldName)) {
                    confidence = reader.getDouble();
                } else if ("boundingRegions".equals(fieldName)) {
                    boundingRegions = reader.readArray(reader1 -> BoundingRegion.fromJson(reader1));
                } else if ("fields".equals(fieldName)) {
                    fields = reader.readMap(reader1 -> DocumentField.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            AnalyzedDocument deserializedAnalyzedDocument = new AnalyzedDocument(documentType, spans, confidence);
            deserializedAnalyzedDocument.boundingRegions = boundingRegions;
            deserializedAnalyzedDocument.fields = fields;
            return deserializedAnalyzedDocument;
        });
    }
}
