// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Bounding polygon on a specific page of the input.
 */
@Immutable
public final class BoundingRegion implements JsonSerializable<BoundingRegion> {

    /*
     * 1-based page number of page containing the bounding region.
     */
    @Generated
    private final int pageNumber;

    /*
     * Bounding polygon on the page, or the entire page if not specified.
     * Coordinates specified relative to the top-left of the page. The numbers
     * represent the x, y values of the polygon vertices, clockwise from the left
     * (-180 degrees inclusive) relative to the element orientation.
     */
    @Generated
    private final List<Double> polygon;

    /**
     * Creates an instance of BoundingRegion class.
     *
     * @param pageNumber the pageNumber value to set.
     * @param polygon the polygon value to set.
     */
    @Generated
    private BoundingRegion(int pageNumber, List<Double> polygon) {
        this.pageNumber = pageNumber;
        this.polygon = polygon;
    }

    /**
     * Get the pageNumber property: 1-based page number of page containing the bounding region.
     *
     * @return the pageNumber value.
     */
    @Generated
    public int getPageNumber() {
        return this.pageNumber;
    }

    /**
     * Get the polygon property: Bounding polygon on the page, or the entire page if not specified.
     * Coordinates specified relative to the top-left of the page. The numbers
     * represent the x, y values of the polygon vertices, clockwise from the left
     * (-180 degrees inclusive) relative to the element orientation.
     *
     * @return the polygon value.
     */
    @Generated
    public List<Double> getPolygon() {
        return this.polygon;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("pageNumber", this.pageNumber);
        jsonWriter.writeArrayField("polygon", this.polygon, (writer, element) -> writer.writeDouble(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BoundingRegion from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of BoundingRegion if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BoundingRegion.
     */
    @Generated
    public static BoundingRegion fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            int pageNumber = 0;
            List<Double> polygon = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("pageNumber".equals(fieldName)) {
                    pageNumber = reader.getInt();
                } else if ("polygon".equals(fieldName)) {
                    polygon = reader.readArray(reader1 -> reader1.getDouble());
                } else {
                    reader.skipChildren();
                }
            }
            return new BoundingRegion(pageNumber, polygon);
        });
    }
}
