// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A formula object.
 */
@Immutable
public final class DocumentFormula implements JsonSerializable<DocumentFormula> {

    /*
     * Formula kind.
     */
    @Generated
    private final DocumentFormulaKind kind;

    /*
     * LaTex expression describing the formula.
     */
    @Generated
    private final String value;

    /*
     * Bounding polygon of the formula, with coordinates specified relative to the
     * top-left of the page. The numbers represent the x, y values of the polygon
     * vertices, clockwise from the left (-180 degrees inclusive) relative to the
     * element orientation.
     */
    @Generated
    private List<Double> polygon;

    /*
     * Location of the formula in the reading order concatenated content.
     */
    @Generated
    private final DocumentSpan span;

    /*
     * Confidence of correctly extracting the formula.
     */
    @Generated
    private final double confidence;

    /**
     * Creates an instance of DocumentFormula class.
     *
     * @param kind the kind value to set.
     * @param value the value value to set.
     * @param span the span value to set.
     * @param confidence the confidence value to set.
     */
    @Generated
    private DocumentFormula(DocumentFormulaKind kind, String value, DocumentSpan span, double confidence) {
        this.kind = kind;
        this.value = value;
        this.span = span;
        this.confidence = confidence;
    }

    /**
     * Get the kind property: Formula kind.
     *
     * @return the kind value.
     */
    @Generated
    public DocumentFormulaKind getKind() {
        return this.kind;
    }

    /**
     * Get the value property: LaTex expression describing the formula.
     *
     * @return the value value.
     */
    @Generated
    public String getValue() {
        return this.value;
    }

    /**
     * Get the polygon property: Bounding polygon of the formula, with coordinates specified relative to the
     * top-left of the page. The numbers represent the x, y values of the polygon
     * vertices, clockwise from the left (-180 degrees inclusive) relative to the
     * element orientation.
     *
     * @return the polygon value.
     */
    @Generated
    public List<Double> getPolygon() {
        return this.polygon;
    }

    /**
     * Get the span property: Location of the formula in the reading order concatenated content.
     *
     * @return the span value.
     */
    @Generated
    public DocumentSpan getSpan() {
        return this.span;
    }

    /**
     * Get the confidence property: Confidence of correctly extracting the formula.
     *
     * @return the confidence value.
     */
    @Generated
    public double getConfidence() {
        return this.confidence;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeJsonField("span", this.span);
        jsonWriter.writeDoubleField("confidence", this.confidence);
        jsonWriter.writeArrayField("polygon", this.polygon, (writer, element) -> writer.writeDouble(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentFormula from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentFormula if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentFormula.
     */
    @Generated
    public static DocumentFormula fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DocumentFormulaKind kind = null;
            String value = null;
            DocumentSpan span = null;
            double confidence = 0.0;
            List<Double> polygon = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    kind = DocumentFormulaKind.fromString(reader.getString());
                } else if ("value".equals(fieldName)) {
                    value = reader.getString();
                } else if ("span".equals(fieldName)) {
                    span = DocumentSpan.fromJson(reader);
                } else if ("confidence".equals(fieldName)) {
                    confidence = reader.getDouble();
                } else if ("polygon".equals(fieldName)) {
                    polygon = reader.readArray(reader1 -> reader1.getDouble());
                } else {
                    reader.skipChildren();
                }
            }
            DocumentFormula deserializedDocumentFormula = new DocumentFormula(kind, value, span, confidence);
            deserializedDocumentFormula.polygon = polygon;
            return deserializedDocumentFormula;
        });
    }
}
