// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * General information regarding the current resource.
 */
@Immutable
public final class DocumentIntelligenceResourceDetails
    implements JsonSerializable<DocumentIntelligenceResourceDetails> {

    /*
     * Details regarding custom document models.
     */
    @Generated
    private final CustomDocumentModelsDetails customDocumentModels;

    /**
     * Creates an instance of DocumentIntelligenceResourceDetails class.
     *
     * @param customDocumentModels the customDocumentModels value to set.
     */
    @Generated
    private DocumentIntelligenceResourceDetails(CustomDocumentModelsDetails customDocumentModels) {
        this.customDocumentModels = customDocumentModels;
    }

    /**
     * Get the customDocumentModels property: Details regarding custom document models.
     *
     * @return the customDocumentModels value.
     */
    @Generated
    public CustomDocumentModelsDetails getCustomDocumentModels() {
        return this.customDocumentModels;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("customDocumentModels", this.customDocumentModels);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentIntelligenceResourceDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentIntelligenceResourceDetails if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentIntelligenceResourceDetails.
     */
    @Generated
    public static DocumentIntelligenceResourceDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomDocumentModelsDetails customDocumentModels = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("customDocumentModels".equals(fieldName)) {
                    customDocumentModels = CustomDocumentModelsDetails.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return new DocumentIntelligenceResourceDetails(customDocumentModels);
        });
    }
}
