// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * An object representing observed text styles.
 */
@Immutable
public final class DocumentStyle implements JsonSerializable<DocumentStyle> {

    /*
     * Is content handwritten?
     */
    @Generated
    private Boolean isHandwritten;

    /*
     * Visually most similar font from among the set of supported font families, with
     * fallback fonts following CSS convention (ex. 'Arial, sans-serif').
     */
    @Generated
    private String similarFontFamily;

    /*
     * Font style.
     */
    @Generated
    private DocumentFontStyle fontStyle;

    /*
     * Font weight.
     */
    @Generated
    private DocumentFontWeight fontWeight;

    /*
     * Foreground color in #rrggbb hexadecimal format.
     */
    @Generated
    private String color;

    /*
     * Background color in #rrggbb hexadecimal format..
     */
    @Generated
    private String backgroundColor;

    /*
     * Location of the text elements in the concatenated content the style applies to.
     */
    @Generated
    private final List<DocumentSpan> spans;

    /*
     * Confidence of correctly identifying the style.
     */
    @Generated
    private final double confidence;

    /**
     * Creates an instance of DocumentStyle class.
     *
     * @param spans the spans value to set.
     * @param confidence the confidence value to set.
     */
    @Generated
    private DocumentStyle(List<DocumentSpan> spans, double confidence) {
        this.spans = spans;
        this.confidence = confidence;
    }

    /**
     * Get the isHandwritten property: Is content handwritten?.
     *
     * @return the isHandwritten value.
     */
    @Generated
    public Boolean isHandwritten() {
        return this.isHandwritten;
    }

    /**
     * Get the similarFontFamily property: Visually most similar font from among the set of supported font families,
     * with
     * fallback fonts following CSS convention (ex. 'Arial, sans-serif').
     *
     * @return the similarFontFamily value.
     */
    @Generated
    public String getSimilarFontFamily() {
        return this.similarFontFamily;
    }

    /**
     * Get the fontStyle property: Font style.
     *
     * @return the fontStyle value.
     */
    @Generated
    public DocumentFontStyle getFontStyle() {
        return this.fontStyle;
    }

    /**
     * Get the fontWeight property: Font weight.
     *
     * @return the fontWeight value.
     */
    @Generated
    public DocumentFontWeight getFontWeight() {
        return this.fontWeight;
    }

    /**
     * Get the color property: Foreground color in #rrggbb hexadecimal format.
     *
     * @return the color value.
     */
    @Generated
    public String getColor() {
        return this.color;
    }

    /**
     * Get the backgroundColor property: Background color in #rrggbb hexadecimal format..
     *
     * @return the backgroundColor value.
     */
    @Generated
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    /**
     * Get the spans property: Location of the text elements in the concatenated content the style applies to.
     *
     * @return the spans value.
     */
    @Generated
    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    /**
     * Get the confidence property: Confidence of correctly identifying the style.
     *
     * @return the confidence value.
     */
    @Generated
    public double getConfidence() {
        return this.confidence;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeDoubleField("confidence", this.confidence);
        jsonWriter.writeBooleanField("isHandwritten", this.isHandwritten);
        jsonWriter.writeStringField("similarFontFamily", this.similarFontFamily);
        jsonWriter.writeStringField("fontStyle", this.fontStyle == null ? null : this.fontStyle.toString());
        jsonWriter.writeStringField("fontWeight", this.fontWeight == null ? null : this.fontWeight.toString());
        jsonWriter.writeStringField("color", this.color);
        jsonWriter.writeStringField("backgroundColor", this.backgroundColor);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentStyle from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentStyle if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentStyle.
     */
    @Generated
    public static DocumentStyle fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<DocumentSpan> spans = null;
            double confidence = 0.0;
            Boolean isHandwritten = null;
            String similarFontFamily = null;
            DocumentFontStyle fontStyle = null;
            DocumentFontWeight fontWeight = null;
            String color = null;
            String backgroundColor = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                } else if ("confidence".equals(fieldName)) {
                    confidence = reader.getDouble();
                } else if ("isHandwritten".equals(fieldName)) {
                    isHandwritten = reader.getNullable(JsonReader::getBoolean);
                } else if ("similarFontFamily".equals(fieldName)) {
                    similarFontFamily = reader.getString();
                } else if ("fontStyle".equals(fieldName)) {
                    fontStyle = DocumentFontStyle.fromString(reader.getString());
                } else if ("fontWeight".equals(fieldName)) {
                    fontWeight = DocumentFontWeight.fromString(reader.getString());
                } else if ("color".equals(fieldName)) {
                    color = reader.getString();
                } else if ("backgroundColor".equals(fieldName)) {
                    backgroundColor = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            DocumentStyle deserializedDocumentStyle = new DocumentStyle(spans, confidence);
            deserializedDocumentStyle.isHandwritten = isHandwritten;
            deserializedDocumentStyle.similarFontFamily = similarFontFamily;
            deserializedDocumentStyle.fontStyle = fontStyle;
            deserializedDocumentStyle.fontWeight = fontWeight;
            deserializedDocumentStyle.color = color;
            deserializedDocumentStyle.backgroundColor = backgroundColor;
            return deserializedDocumentStyle;
        });
    }
}
