/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class BatchCreateRequest
implements JsonSerializable<BatchCreateRequest> {
    private final String endpoint;
    private final String inputFileId;
    private final String completionWindow;
    private Map<String, String> metadata;

    public BatchCreateRequest(String endpoint, String inputFileId, String completionWindow) {
        this.endpoint = endpoint;
        this.inputFileId = inputFileId;
        this.completionWindow = completionWindow;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getInputFileId() {
        return this.inputFileId;
    }

    public String getCompletionWindow() {
        return this.completionWindow;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public BatchCreateRequest setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpoint", this.endpoint);
        jsonWriter.writeStringField("input_file_id", this.inputFileId);
        jsonWriter.writeStringField("completion_window", this.completionWindow);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static BatchCreateRequest fromJson(JsonReader jsonReader) throws IOException {
        return (BatchCreateRequest)jsonReader.readObject(reader -> {
            String endpoint = null;
            String inputFileId = null;
            String completionWindow = null;
            Map metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpoint".equals(fieldName)) {
                    endpoint = reader.getString();
                    continue;
                }
                if ("input_file_id".equals(fieldName)) {
                    inputFileId = reader.getString();
                    continue;
                }
                if ("completion_window".equals(fieldName)) {
                    completionWindow = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            BatchCreateRequest deserializedBatchCreateRequest = new BatchCreateRequest(endpoint, inputFileId, completionWindow);
            deserializedBatchCreateRequest.metadata = metadata;
            return deserializedBatchCreateRequest;
        });
    }
}

