/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.PredictionContentType;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class PredictionContent
implements JsonSerializable<PredictionContent> {
    private final PredictionContentType type = PredictionContentType.CONTENT;
    private final BinaryData content;

    public PredictionContent(BinaryData content) {
        this.content = content;
    }

    public PredictionContentType getType() {
        return this.type;
    }

    public BinaryData getContent() {
        return this.content;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeFieldName("content");
        this.content.writeTo(jsonWriter);
        return jsonWriter.writeEndObject();
    }

    public static PredictionContent fromJson(JsonReader jsonReader) throws IOException {
        return (PredictionContent)jsonReader.readObject(reader -> {
            BinaryData content = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                reader.skipChildren();
            }
            return new PredictionContent(content);
        });
    }
}

