/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesResponseUsageOutputTokensDetails;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesResponseUsage
implements JsonSerializable<ResponsesResponseUsage> {
    private final int inputTokens;
    private final int outputTokens;
    private final int totalTokens;
    private final ResponsesResponseUsageOutputTokensDetails outputTokensDetails;

    private ResponsesResponseUsage(int inputTokens, int outputTokens, int totalTokens, ResponsesResponseUsageOutputTokensDetails outputTokensDetails) {
        this.inputTokens = inputTokens;
        this.outputTokens = outputTokens;
        this.totalTokens = totalTokens;
        this.outputTokensDetails = outputTokensDetails;
    }

    public int getInputTokens() {
        return this.inputTokens;
    }

    public int getOutputTokens() {
        return this.outputTokens;
    }

    public int getTotalTokens() {
        return this.totalTokens;
    }

    public ResponsesResponseUsageOutputTokensDetails getOutputTokensDetails() {
        return this.outputTokensDetails;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("input_tokens", this.inputTokens);
        jsonWriter.writeIntField("output_tokens", this.outputTokens);
        jsonWriter.writeIntField("total_tokens", this.totalTokens);
        jsonWriter.writeJsonField("output_tokens_details", (JsonSerializable)this.outputTokensDetails);
        return jsonWriter.writeEndObject();
    }

    public static ResponsesResponseUsage fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesResponseUsage)jsonReader.readObject(reader -> {
            int inputTokens = 0;
            int outputTokens = 0;
            int totalTokens = 0;
            ResponsesResponseUsageOutputTokensDetails outputTokensDetails = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("input_tokens".equals(fieldName)) {
                    inputTokens = reader.getInt();
                    continue;
                }
                if ("output_tokens".equals(fieldName)) {
                    outputTokens = reader.getInt();
                    continue;
                }
                if ("total_tokens".equals(fieldName)) {
                    totalTokens = reader.getInt();
                    continue;
                }
                if ("output_tokens_details".equals(fieldName)) {
                    outputTokensDetails = ResponsesResponseUsageOutputTokensDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new ResponsesResponseUsage(inputTokens, outputTokens, totalTokens, outputTokensDetails);
        });
    }
}

