/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.common;

import com.azure.communication.common.CommunicationCloudEnvironment;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;

public final class TeamsExtensionUserIdentifier
extends CommunicationIdentifier {
    private final ClientLogger logger = new ClientLogger(TeamsExtensionUserIdentifier.class);
    private final String userId;
    private final String tenantId;
    private final String resourceId;
    private CommunicationCloudEnvironment cloudEnvironment;

    public TeamsExtensionUserIdentifier(String userId, String tenantId, String resourceId) {
        if (CoreUtils.isNullOrEmpty((CharSequence)userId)) {
            throw new IllegalArgumentException("The initialization parameter [userId] cannot be null or empty.");
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)tenantId)) {
            throw new IllegalArgumentException("The initialization parameter [tenantId] cannot be null or empty.");
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)resourceId)) {
            throw new IllegalArgumentException("The initialization parameter [resourceId] cannot be null or empty.");
        }
        this.userId = userId;
        this.tenantId = tenantId;
        this.resourceId = resourceId;
        this.cloudEnvironment = CommunicationCloudEnvironment.PUBLIC;
        this.generateRawId();
    }

    @Override
    public TeamsExtensionUserIdentifier setRawId(String rawId) {
        super.setRawId(rawId);
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public CommunicationCloudEnvironment getCloudEnvironment() {
        return this.cloudEnvironment;
    }

    public TeamsExtensionUserIdentifier setCloudEnvironment(CommunicationCloudEnvironment cloudEnvironment) {
        if (cloudEnvironment == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The parameter [cloudEnvironment] cannot be null."));
        }
        this.cloudEnvironment = cloudEnvironment;
        this.generateRawId();
        return this;
    }

    private void generateRawId() {
        if (this.cloudEnvironment.equals((Object)CommunicationCloudEnvironment.DOD)) {
            super.setRawId("8:dod-acs:" + this.resourceId + "_" + this.tenantId + "_" + this.userId);
        } else if (this.cloudEnvironment.equals((Object)CommunicationCloudEnvironment.GCCH)) {
            super.setRawId("8:gcch-acs:" + this.resourceId + "_" + this.tenantId + "_" + this.userId);
        } else {
            super.setRawId("8:acs:" + this.resourceId + "_" + this.tenantId + "_" + this.userId);
        }
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof TeamsExtensionUserIdentifier)) {
            return false;
        }
        return ((TeamsExtensionUserIdentifier)that).getRawId().equals(this.getRawId());
    }

    @Override
    public int hashCode() {
        return this.getRawId().hashCode();
    }
}

