// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.email.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The EmailsGetSendResultHeaders model. */
@Fluent
public final class EmailsGetSendResultHeaders {
    /*
     * The retry-after property.
     */
    @JsonProperty(value = "retry-after")
    private Integer retryAfter;

    // HttpHeaders containing the raw property values.
    /**
     * Creates an instance of EmailsGetSendResultHeaders class.
     *
     * @param rawHeaders The raw HttpHeaders that will be used to create the property values.
     */
    public EmailsGetSendResultHeaders(HttpHeaders rawHeaders) {
        String retryAfter = rawHeaders.getValue(HttpHeaderName.RETRY_AFTER);
        if (retryAfter != null) {
            this.retryAfter = Integer.parseInt(retryAfter);
        }
    }

    /**
     * Get the retryAfter property: The retry-after property.
     *
     * @return the retryAfter value.
     */
    public Integer getRetryAfter() {
        return this.retryAfter;
    }

    /**
     * Set the retryAfter property: The retry-after property.
     *
     * @param retryAfter the retryAfter value to set.
     * @return the EmailsGetSendResultHeaders object itself.
     */
    public EmailsGetSendResultHeaders setRetryAfter(Integer retryAfter) {
        this.retryAfter = retryAfter;
        return this;
    }
}
