/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.email.implementation.models;

import com.azure.communication.email.implementation.models.EmailAttachment;
import com.azure.communication.email.implementation.models.EmailContent;
import com.azure.communication.email.implementation.models.EmailRecipients;
import com.azure.communication.email.models.EmailAddress;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class EmailMessage
implements JsonSerializable<EmailMessage> {
    private Map<String, String> headers;
    private final String senderAddress;
    private final EmailContent content;
    private final EmailRecipients recipients;
    private List<EmailAttachment> attachments;
    private List<EmailAddress> replyTo;
    private Boolean userEngagementTrackingDisabled;

    public EmailMessage(String senderAddress, EmailContent content, EmailRecipients recipients) {
        this.senderAddress = senderAddress;
        this.content = content;
        this.recipients = recipients;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public EmailMessage setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public String getSenderAddress() {
        return this.senderAddress;
    }

    public EmailContent getContent() {
        return this.content;
    }

    public EmailRecipients getRecipients() {
        return this.recipients;
    }

    public List<EmailAttachment> getAttachments() {
        return this.attachments;
    }

    public EmailMessage setAttachments(List<EmailAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public List<EmailAddress> getReplyTo() {
        return this.replyTo;
    }

    public EmailMessage setReplyTo(List<EmailAddress> replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public Boolean isUserEngagementTrackingDisabled() {
        return this.userEngagementTrackingDisabled;
    }

    public EmailMessage setUserEngagementTrackingDisabled(Boolean userEngagementTrackingDisabled) {
        this.userEngagementTrackingDisabled = userEngagementTrackingDisabled;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("senderAddress", this.senderAddress);
        jsonWriter.writeJsonField("content", (JsonSerializable)this.content);
        jsonWriter.writeJsonField("recipients", (JsonSerializable)this.recipients);
        jsonWriter.writeMapField("headers", this.headers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("attachments", this.attachments, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("replyTo", this.replyTo, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("userEngagementTrackingDisabled", this.userEngagementTrackingDisabled);
        return jsonWriter.writeEndObject();
    }

    public static EmailMessage fromJson(JsonReader jsonReader) throws IOException {
        return (EmailMessage)jsonReader.readObject(reader -> {
            boolean senderAddressFound = false;
            String senderAddress = null;
            boolean contentFound = false;
            EmailContent content = null;
            boolean recipientsFound = false;
            EmailRecipients recipients = null;
            Map headers = null;
            List attachments = null;
            List replyTo = null;
            Boolean userEngagementTrackingDisabled = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("senderAddress".equals(fieldName)) {
                    senderAddress = reader.getString();
                    senderAddressFound = true;
                    continue;
                }
                if ("content".equals(fieldName)) {
                    content = EmailContent.fromJson(reader);
                    contentFound = true;
                    continue;
                }
                if ("recipients".equals(fieldName)) {
                    recipients = EmailRecipients.fromJson(reader);
                    recipientsFound = true;
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    headers = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("attachments".equals(fieldName)) {
                    attachments = reader.readArray(reader1 -> EmailAttachment.fromJson(reader1));
                    continue;
                }
                if ("replyTo".equals(fieldName)) {
                    replyTo = reader.readArray(reader1 -> EmailAddress.fromJson(reader1));
                    continue;
                }
                if ("userEngagementTrackingDisabled".equals(fieldName)) {
                    userEngagementTrackingDisabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (senderAddressFound && contentFound && recipientsFound) {
                EmailMessage deserializedEmailMessage = new EmailMessage(senderAddress, content, recipients);
                deserializedEmailMessage.headers = headers;
                deserializedEmailMessage.attachments = attachments;
                deserializedEmailMessage.replyTo = replyTo;
                deserializedEmailMessage.userEngagementTrackingDisabled = userEngagementTrackingDisabled;
                return deserializedEmailMessage;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!senderAddressFound) {
                missingProperties.add("senderAddress");
            }
            if (!contentFound) {
                missingProperties.add("content");
            }
            if (!recipientsFound) {
                missingProperties.add("recipients");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

