/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.email.implementation.models;

import com.azure.communication.email.implementation.models.ErrorDetail;
import com.azure.communication.email.models.EmailSendStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class EmailSendResult
implements JsonSerializable<EmailSendResult> {
    private final String id;
    private final EmailSendStatus status;
    private ErrorDetail error;

    public EmailSendResult(String id, EmailSendStatus status) {
        this.id = id;
        this.status = status;
    }

    public String getId() {
        return this.id;
    }

    public EmailSendStatus getStatus() {
        return this.status;
    }

    public ErrorDetail getError() {
        return this.error;
    }

    public EmailSendResult setError(ErrorDetail error) {
        this.error = error;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static EmailSendResult fromJson(JsonReader jsonReader) throws IOException {
        return (EmailSendResult)jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean statusFound = false;
            EmailSendStatus status = null;
            ErrorDetail error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = EmailSendStatus.fromString(reader.getString());
                    statusFound = true;
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = ErrorDetail.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound && statusFound) {
                EmailSendResult deserializedEmailSendResult = new EmailSendResult(id, status);
                deserializedEmailSendResult.error = error;
                return deserializedEmailSendResult;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!statusFound) {
                missingProperties.add("status");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

